/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.networking;

import com.google.common.hash.Hashing;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.glasslauncher.mods.networking.GlassNetworkHandler;
import net.glasslauncher.mods.networking.GlassPacket;
import net.glasslauncher.mods.networking.GlassPacketListener;
import net.glasslauncher.mods.networking.helpers.PacketHelperClientImpl;
import net.glasslauncher.mods.networking.helpers.PacketHelperImpl;
import net.glasslauncher.mods.networking.helpers.PacketHelperServerImpl;
import net.minecraft.class_187;
import net.minecraft.class_219;
import net.minecraft.class_240;
import net.minecraft.class_54;
import net.minecraft.class_69;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

public class GlassNetworking
implements ModInitializer {
    public static final long MASK = Hashing.sipHash24().hashUnencodedChars((CharSequence)"glassnetworking").asLong();
    public static final int PACKET_ID = 253;
    public static final Logger LOGGER = LogManager.getLogger((String)"GlassNetworking|Mod");
    private static boolean serverHasNetworking = false;
    private static final PacketHelperImpl PACKET_HELPER = FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT) ? new PacketHelperClientImpl() : new PacketHelperServerImpl();
    static final ArrayList<String> SERVER_BOUND_PACKETS = new ArrayList();
    static final ArrayList<String> CLIENT_BOUND_PACKETS = new ArrayList();
    static final HashMap<String, BiConsumer<GlassPacket, class_240>> PACKET_HANDLERS = new HashMap();

    public static int writeAndGetNbtLength(class_187 element, OutputStream dataOutput) {
        DataOutputStream outputStream = new DataOutputStream(dataOutput);
        element.method_631((DataOutput)outputStream);
        try {
            outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return outputStream.size();
    }

    public static boolean isClientPacket(String fullId) {
        return CLIENT_BOUND_PACKETS.contains(fullId);
    }

    public static boolean isServerPacket(String fullId) {
        return SERVER_BOUND_PACKETS.contains(fullId);
    }

    public static void sendToServer(GlassPacket packet) {
        PACKET_HELPER.send(packet);
    }

    public static void sendToPlayer(class_54 player, GlassPacket packet) {
        PACKET_HELPER.sendTo(player, packet);
    }

    public void onInitialize() {
        FabricLoader.getInstance().getEntrypoints("glassnetworking", GlassPacketListener.class).forEach(GlassPacketListener::registerGlassPackets);
        LOGGER.info("Registered {} packets, of which {} are client bound, and {} are server bound.", (Object)PACKET_HANDLERS.size(), (Object)CLIENT_BOUND_PACKETS.size(), (Object)SERVER_BOUND_PACKETS.size());
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean serverHasNetworking() {
        class_219 handler = Minecraft.field_2791.method_2145();
        if (handler == null) {
            return false;
        }
        return serverHasNetworking;
    }

    @Deprecated
    @Environment(value=EnvType.CLIENT)
    @ApiStatus.Internal
    public static void setServerHasNetworking(boolean hasNetworking) {
        serverHasNetworking = hasNetworking;
    }

    @Environment(value=EnvType.SERVER)
    public static boolean clientHasNetworking(class_69 entity) {
        return ((GlassNetworkHandler)entity.field_255).glass_Networking$hasGlassNetworking();
    }
}

