/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.accessoryapi.impl.mixin;

import com.matthewperiut.accessoryapi.api.BossLivingEntity;
import com.matthewperiut.accessoryapi.api.PlayerExtraHP;
import net.minecraft.class_127;
import net.minecraft.class_18;
import net.minecraft.class_54;
import net.minecraft.class_57;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_127.class}, priority=900)
public abstract class LivingBaseMixin
extends class_57
implements BossLivingEntity {
    @Shadow
    public int field_1009;
    @Shadow
    public int field_1036;
    @Unique
    int maxHP = -1;
    @Unique
    String parsedBossName = "";
    @Unique
    int prevHP = 0;

    private LivingBaseMixin(class_18 arg) {
        super(arg);
    }

    @Inject(method={"heal"}, at={@At(value="HEAD")}, cancellable=true)
    public void addHealth(int health, CallbackInfo ci) {
        int extraHP = 0;
        LivingBaseMixin livingBaseMixin = this;
        if (livingBaseMixin instanceof PlayerExtraHP) {
            PlayerExtraHP playerExtraHP = (PlayerExtraHP)((Object)livingBaseMixin);
            extraHP = playerExtraHP.getExtraHP();
        }
        if (this.field_1036 > 0) {
            this.field_1036 += health;
            if (this.field_1036 > 20 + extraHP) {
                this.field_1036 = 20 + extraHP;
            }
            this.field_1613 = this.field_1009 / 2;
        }
        ci.cancel();
    }

    @Override
    public void setBoss(boolean boss) {
        this.method_1326(6, boss);
        this.field_1616.method_1509(30, (Object)this.field_1036);
        this.prevHP = this.field_1036;
    }

    @Override
    public boolean isBoss() {
        return this.method_1345(6);
    }

    @Override
    public int getHP() {
        return this.field_1616.method_1508(30);
    }

    @Override
    public int getMaxHP() {
        if (this.maxHP == -1) {
            this.maxHP = this.field_1036;
            LivingBaseMixin livingBaseMixin = this;
            if (livingBaseMixin instanceof PlayerExtraHP) {
                PlayerExtraHP extraHP = (PlayerExtraHP)((Object)livingBaseMixin);
                this.maxHP += extraHP.getExtraHP();
            }
        }
        return this.maxHP;
    }

    @Override
    public String getName() {
        if (this.parsedBossName.isEmpty()) {
            LivingBaseMixin livingBaseMixin = this;
            if (livingBaseMixin instanceof class_54) {
                class_54 player = (class_54)livingBaseMixin;
                this.parsedBossName = player.field_528 + " ";
            } else {
                String input = this.method_1337();
                StringBuilder output = new StringBuilder();
                for (int i = 0; i < input.length(); ++i) {
                    if (Character.isUpperCase(input.charAt(i)) && i != 0) {
                        output.append(" ");
                    }
                    output.append(input.charAt(i));
                }
                this.parsedBossName = output + " ";
                String customTitle = this.getCustomTitle();
                if (!customTitle.isEmpty()) {
                    this.parsedBossName = this.parsedBossName + customTitle + " ";
                }
            }
        }
        return this.parsedBossName;
    }

    @Inject(method={"initDataTracker"}, at={@At(value="RETURN")})
    protected void initDataTrackerBossHP(CallbackInfo ci) {
        this.field_1616.method_1502(30, (Object)0);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    protected void updateHP(CallbackInfo ci) {
        if (this.isBoss()) {
            if (this.prevHP == 0) {
                this.prevHP = this.field_1036;
            } else if (this.field_1036 != this.prevHP) {
                this.field_1616.method_1509(30, (Object)this.field_1036);
                this.prevHP = this.field_1036;
            }
        }
    }
}

