/*
 * Decompiled with CFR 0.152.
 */
package com.github.telvarost.clientsideessentials.mixin;

import com.github.telvarost.clientsideessentials.Config;
import java.awt.Canvas;
import java.awt.geom.AffineTransform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_32;
import net.minecraft.client.Minecraft;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @Shadow
    public Canvas field_2811;
    @Shadow
    public int field_2802;
    @Shadow
    public int field_2803;

    @Redirect(method={"run"}, at=@At(value="INVOKE", target="Ljava/awt/Canvas;getWidth()I", ordinal=1), remap=false)
    public int fixWidth(Canvas canvas) {
        if (Config.config.GRAPHICS_CONFIG.FIX_SCREEN_SCALING.booleanValue()) {
            AffineTransform transform = canvas.getGraphicsConfiguration().getDefaultTransform();
            return (int)Math.ceil((double)canvas.getParent().getWidth() * transform.getScaleX());
        }
        return canvas.getWidth();
    }

    @Redirect(method={"run"}, at=@At(value="INVOKE", target="Ljava/awt/Canvas;getHeight()I", ordinal=1), remap=false)
    public int fixHeight(Canvas canvas) {
        if (Config.config.GRAPHICS_CONFIG.FIX_SCREEN_SCALING.booleanValue()) {
            AffineTransform transform = canvas.getGraphicsConfiguration().getDefaultTransform();
            return (int)Math.ceil((double)canvas.getParent().getHeight() * transform.getScaleY());
        }
        return canvas.getHeight();
    }

    @Inject(method={"run"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;resize(II)V")})
    public void fixCanvasSize(CallbackInfo ci) {
        if (Config.config.GRAPHICS_CONFIG.FIX_SCREEN_SCALING.booleanValue()) {
            this.field_2811.setBounds(0, 0, this.field_2802, this.field_2803);
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="RETURN")})
    public void openScreen(class_32 par1, CallbackInfo ci) {
        if (Config.config.GRAPHICS_CONFIG.FIX_SCREEN_SCALING.booleanValue()) {
            AffineTransform transform = this.field_2811.getGraphicsConfiguration().getDefaultTransform();
            int fixedWidth = (int)Math.ceil((double)this.field_2811.getParent().getWidth() * transform.getScaleX());
            int fixedHeight = (int)Math.ceil((double)this.field_2811.getParent().getHeight() * transform.getScaleY());
            this.field_2811.setBounds(0, 0, fixedWidth, fixedHeight);
        }
    }
}

