/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.aether.entity.special;

import com.matthewperiut.aether.entity.AetherEntities;
import com.matthewperiut.aether.mixin.access.EntityAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_127;
import net.minecraft.class_15;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.server.entity.EntitySpawnDataProvider;
import net.modificationstation.stationapi.api.server.entity.HasTrackingParameters;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.TriState;

@HasTrackingParameters(trackingDistance=50, sendVelocity=TriState.TRUE, updatePeriod=1)
public class EntityCloudParachute
extends class_57
implements EntitySpawnDataProvider {
    private class_127 entityUsing;
    private boolean justServerSpawned = false;
    private static Map<class_127, EntityCloudParachute> cloudMap = new HashMap<class_127, EntityCloudParachute>();
    private static final float MAX_FALL_SPEED = 0.25f;
    private static final double ANIM_RADIUS = 0.75;
    public boolean gold;

    public EntityCloudParachute(class_18 world) {
        super(world);
        this.method_1321(1.0f, 1.0f);
    }

    public EntityCloudParachute(class_18 world, double d, double d1, double d2) {
        this(world);
        this.method_1338(d, d1, d2, this.field_1606, this.field_1607);
        this.justServerSpawned = true;
    }

    public EntityCloudParachute(class_18 world, class_127 entityliving, boolean bool) {
        this(world);
        if (entityliving == null) {
            throw new IllegalArgumentException("entityliving cannot be null.");
        }
        this.entityUsing = entityliving;
        cloudMap.put(entityliving, this);
        this.field_1597 = this.field_1600;
        this.field_1598 = this.field_1601;
        this.field_1599 = this.field_1602;
        this.moveToEntityUsing();
        this.gold = bool;
    }

    public static EntityCloudParachute getCloudBelongingToEntity(class_127 entity) {
        return cloudMap.get(entity);
    }

    public class_18 getWorld() {
        return this.field_1596;
    }

    public void die() {
        if (this.entityUsing != null) {
            if (cloudMap.containsKey(this.entityUsing)) {
                cloudMap.remove(this.entityUsing);
            }
            for (int i = 0; i < 32; ++i) {
                EntityCloudParachute.doCloudSmoke(this.field_1596, this.entityUsing);
            }
            this.field_1596.method_191((class_57)this.entityUsing, "cloud", 1.0f, 1.0f / (this.field_1644.nextFloat() * 0.1f + 0.95f));
        }
        this.entityUsing = null;
        this.field_1630 = true;
    }

    public static void doCloudSmoke(class_18 world, class_127 entityliving) {
        double x = entityliving.field_1600 + ((EntityAccessor)entityliving).getRand().nextDouble() * 0.75 * 2.0 - 0.75;
        double y = entityliving.field_1610.field_130 - 0.5 + ((EntityAccessor)entityliving).getRand().nextDouble() * 0.75 * 2.0 - 0.75;
        double z = entityliving.field_1602 + ((EntityAccessor)entityliving).getRand().nextDouble() * 0.75 * 2.0 - 0.75;
        world.method_178("white_cloud_smoke", x, y, z, 0.0, 0.0, 0.0);
    }

    public static boolean entityHasRoomForCloud(class_18 world, class_127 entityliving) {
        class_25 boundingBox = class_25.method_87((double)(entityliving.field_1600 - 0.5), (double)(entityliving.field_1610.field_130 - 1.0), (double)(entityliving.field_1602 - 0.5), (double)(entityliving.field_1600 + 0.5), (double)entityliving.field_1610.field_130, (double)(entityliving.field_1602 + 0.5));
        return world.method_190((class_57)entityliving, boundingBox).size() == 0 && !world.method_207(boundingBox, class_15.field_985);
    }

    protected void method_1310() {
    }

    public boolean method_1364(double d) {
        return this.entityUsing != null ? this.entityUsing.method_1364(d) : super.method_1364(d);
    }

    public boolean method_1356() {
        return true;
    }

    public class_25 method_1381() {
        return this.field_1610;
    }

    public void method_1370() {
        if (!this.field_1630) {
            if (this.entityUsing == null) {
                if (this.field_1596.field_180 && !this.justServerSpawned) {
                    this.die();
                    return;
                }
                this.justServerSpawned = false;
                this.entityUsing = this.findUser();
                if (this.entityUsing == null) {
                    this.die();
                    return;
                }
                cloudMap.put(this.entityUsing, this);
            }
            if (this.entityUsing.field_1604 < -0.25) {
                this.entityUsing.field_1604 = -0.25;
            }
            ((EntityAccessor)this.entityUsing).setFallDistance(0.0f);
            EntityCloudParachute.doCloudSmoke(this.field_1596, this.entityUsing);
            this.moveToEntityUsing();
        }
    }

    private class_127 findUser() {
        List entities = this.field_1596.method_175(class_127.class, this.field_1610.method_92().method_102(0.0, 1.0, 0.0));
        double minDeltaSquared = -1.0;
        class_127 entityliving = null;
        for (int i = 0; i < entities.size(); ++i) {
            class_127 entitylivingtemp = (class_127)entities.get(i);
            if (!entitylivingtemp.method_1318()) continue;
            double xDelta = this.field_1600 - entitylivingtemp.field_1600;
            double yDelta = this.field_1610.field_133 - entitylivingtemp.field_1610.field_130;
            double zDelta = this.field_1602 - entitylivingtemp.field_1602;
            double deltaSquared = xDelta * xDelta + yDelta * yDelta + zDelta * zDelta;
            if (minDeltaSquared != -1.0 && !(deltaSquared < minDeltaSquared)) continue;
            minDeltaSquared = deltaSquared;
            entityliving = entitylivingtemp;
        }
        return entityliving;
    }

    private void moveToEntityUsing() {
        this.method_1338(this.entityUsing.field_1600, this.entityUsing.field_1610.field_130 - (double)(this.field_1633 / 2.0f), this.entityUsing.field_1602, this.entityUsing.field_1606, this.entityUsing.field_1607);
        this.field_1603 = this.entityUsing.field_1603;
        this.field_1604 = this.entityUsing.field_1604;
        this.field_1605 = this.entityUsing.field_1605;
        this.field_1606 = this.entityUsing.field_1606;
        if (this.isCollided()) {
            this.die();
        }
    }

    private boolean isCollided() {
        return this.field_1596.method_190((class_57)this, this.field_1610).size() > 0 || this.field_1596.method_207(this.field_1610, class_15.field_985);
    }

    public void method_1354(class_54 entityplayer) {
    }

    protected void method_1363(class_8 nbttagcompound) {
    }

    protected void method_1368(class_8 nbttagcompound) {
    }

    public Identifier getHandlerIdentifier() {
        return AetherEntities.MOD_ID.id("CloudParachute");
    }
}

