/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.aether.gen.dim;

import com.matthewperiut.aether.Aether;
import com.matthewperiut.aether.block.AetherBlocks;
import com.matthewperiut.aether.gen.biome.AetherBiomes;
import com.matthewperiut.aether.gen.feature.AetherGenClouds;
import com.matthewperiut.aether.gen.feature.AetherGenDungeonBronze;
import com.matthewperiut.aether.gen.feature.AetherGenDungeonSilver;
import com.matthewperiut.aether.gen.feature.AetherGenFlowers;
import com.matthewperiut.aether.gen.feature.AetherGenGoldenOak;
import com.matthewperiut.aether.gen.feature.AetherGenLiquids;
import com.matthewperiut.aether.gen.feature.AetherGenMinable;
import com.matthewperiut.aether.gen.feature.AetherGenQuicksoil;
import com.matthewperiut.aether.gen.feature.AetherGenSkyroot;
import com.matthewperiut.aether.optional.StapiNewCaveImpl;
import java.util.Random;
import net.minecraft.class_105;
import net.minecraft.class_123;
import net.minecraft.class_153;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_209;
import net.minecraft.class_239;
import net.minecraft.class_415;
import net.minecraft.class_43;
import net.minecraft.class_51;
import net.minecraft.class_62;
import net.minecraft.class_624;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.impl.world.chunk.ChunkSection;
import net.modificationstation.stationapi.impl.world.chunk.FlattenedChunk;

public class ChunkProviderAether
implements class_51 {
    public static int gumCount;
    private final Random random;
    private final class_209 minLimitPerlinNoise;
    private final class_209 maxLimitPerlinNoise;
    private final class_209 perlinNoise1;
    private final class_209 perlinNoise2;
    private final class_209 perlinNoise3;
    private final class_18 world;
    private final class_105 cave = new class_415();
    public class_209 floatingIslandScale;
    public class_209 floatingIslandNoise;
    public class_209 forestNoise;
    double[] perlinNoiseBuffer;
    double[] minLimitPerlinNoiseBuffer;
    double[] maxLimitPerlinNoiseBuffer;
    double[] scaleNoiseBuffer;
    double[] depthNoiseBuffer;
    int[][] waterDepths = new int[32][32];
    private double[] heightMap;
    private double[] sandBuffer = new double[256];
    private double[] gravelBuffer = new double[256];
    private double[] depthBuffer = new double[256];
    private class_153[] biomes;
    private double[] temperatures;

    public ChunkProviderAether(class_18 world, long seed) {
        this.world = world;
        if (!Aether.OLDSTAPI) {
            StapiNewCaveImpl.giveStapiWhatItWants(this.cave, world);
        }
        this.random = new Random(seed);
        this.minLimitPerlinNoise = new class_209(this.random, 16);
        this.maxLimitPerlinNoise = new class_209(this.random, 16);
        this.perlinNoise1 = new class_209(this.random, 8);
        this.perlinNoise2 = new class_209(this.random, 4);
        this.perlinNoise3 = new class_209(this.random, 4);
        this.floatingIslandScale = new class_209(this.random, 10);
        this.floatingIslandNoise = new class_209(this.random, 16);
        this.forestNoise = new class_209(this.random, 8);
    }

    public void buildTerrain(int chunkX, int chunkZ, FlattenedChunk chunk, class_153[] biomes, double[] temperatures) {
        int sizeXZ = 2;
        int sizeXZPlus1 = sizeXZ + 1;
        int sizeY = 33;
        int sizeYPlus1 = sizeXZ + 1;
        this.heightMap = this.generateHeightMap(this.heightMap, chunkX * sizeXZ, 0, chunkZ * sizeXZ, sizeXZPlus1, sizeY, sizeYPlus1);
        for (int xSection = 0; xSection < sizeXZ; ++xSection) {
            for (int zSection = 0; zSection < sizeXZ; ++zSection) {
                for (int yChunk = 0; yChunk < 32; ++yChunk) {
                    double yLerpAmount = 0.25;
                    double density00 = this.heightMap[(xSection * sizeYPlus1 + zSection) * sizeY + yChunk];
                    double density01 = this.heightMap[(xSection * sizeYPlus1 + zSection + 1) * sizeY + yChunk];
                    double density10 = this.heightMap[((xSection + 1) * sizeYPlus1 + zSection) * sizeY + yChunk];
                    double density11 = this.heightMap[((xSection + 1) * sizeYPlus1 + zSection + 1) * sizeY + yChunk];
                    double yDelta00 = (this.heightMap[(xSection * sizeYPlus1 + zSection) * sizeY + yChunk + 1] - density00) * yLerpAmount;
                    double yDelta01 = (this.heightMap[(xSection * sizeYPlus1 + zSection + 1) * sizeY + yChunk + 1] - density01) * yLerpAmount;
                    double yDelta10 = (this.heightMap[((xSection + 1) * sizeYPlus1 + zSection) * sizeY + yChunk + 1] - density10) * yLerpAmount;
                    double yDelta11 = (this.heightMap[((xSection + 1) * sizeYPlus1 + zSection + 1) * sizeY + yChunk + 1] - density11) * yLerpAmount;
                    for (int ySubChunk = 0; ySubChunk < 4; ++ySubChunk) {
                        double xLerpAmount = 0.125;
                        double density0 = density00;
                        double density1 = density01;
                        double xDelta0 = (density10 - density00) * xLerpAmount;
                        double xDelta1 = (density11 - density01) * xLerpAmount;
                        for (int xSubChunk = 0; xSubChunk < 8; ++xSubChunk) {
                            double zLerpAmount = 0.125;
                            double density = density0;
                            double zDelta = (density1 - density0) * zLerpAmount;
                            for (int zSubChunk = 0; zSubChunk < 8; ++zSubChunk) {
                                if (density > 0.0) {
                                    int x = xSubChunk + xSection * 8;
                                    int y = yChunk * 4 + ySubChunk;
                                    int z = zSubChunk + zSection * 8;
                                    ChunkSection section = chunk.getOrCreateSection(y, false);
                                    if (section != null) {
                                        section.setBlockState(x, y & 0xF, z, AetherBlocks.Holystone.getDefaultState());
                                    }
                                }
                                density += zDelta;
                            }
                            density0 += xDelta0;
                            density1 += xDelta1;
                        }
                        density00 += yDelta00;
                        density01 += yDelta01;
                        density10 += yDelta10;
                        density11 += yDelta11;
                    }
                }
            }
        }
    }

    public void buildSurfaces(int chunkX, int chunkZ, FlattenedChunk chunk, class_153[] biomes) {
        double noiseScale = 0.03125;
        this.sandBuffer = this.perlinNoise2.method_1514(this.sandBuffer, (double)(chunkX * 16), (double)(chunkZ * 16), 0.0, 16, 16, 1, noiseScale, noiseScale, 1.0);
        this.gravelBuffer = this.perlinNoise2.method_1514(this.gravelBuffer, (double)(chunkX * 16), 109.0134, (double)(chunkZ * 16), 16, 1, 16, noiseScale, 1.0, noiseScale);
        this.depthBuffer = this.perlinNoise3.method_1514(this.depthBuffer, (double)(chunkX * 16), (double)(chunkZ * 16), 0.0, 16, 16, 1, noiseScale * 2.0, noiseScale * 2.0, noiseScale * 2.0);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                class_153 biome = AetherBiomes.AETHER;
                int surfaceDepth = (int)(this.depthBuffer[x + z * 16] / 3.0 + 3.0 + this.random.nextDouble() * 0.25);
                int runDepth = -1;
                class_17 topBlock = AetherBlocks.Grass;
                class_17 fillerBlock = AetherBlocks.Dirt;
                class_17 stoneBlock = AetherBlocks.Holystone;
                for (int y = 127; y >= 0; --y) {
                    ChunkSection section = chunk.getOrCreateSection(y, false);
                    if (section == null) continue;
                    BlockState currentState = section.getBlockState(z, y & 0xF, x);
                    class_17 currentBlock = currentState.getBlock();
                    if (currentBlock == class_17.field_1937[0]) {
                        runDepth = -1;
                        continue;
                    }
                    if (currentBlock != stoneBlock) continue;
                    if (runDepth == -1) {
                        if (surfaceDepth <= 0) {
                            topBlock = null;
                            fillerBlock = stoneBlock;
                        } else {
                            topBlock = AetherBlocks.Grass;
                            fillerBlock = AetherBlocks.Dirt;
                        }
                        runDepth = surfaceDepth;
                        if (y < 0 || topBlock == null || topBlock == currentBlock) continue;
                        section.setBlockState(z, y & 0xF, x, topBlock.getDefaultState());
                        continue;
                    }
                    if (runDepth <= 0) continue;
                    --runDepth;
                    if (fillerBlock == currentBlock) continue;
                    section.setBlockState(z, y & 0xF, x, fillerBlock.getDefaultState());
                }
            }
        }
    }

    public boolean method_1802(int x, int z) {
        return false;
    }

    public class_43 method_1807(int chunkX, int chunkZ) {
        return this.method_1806(chunkX, chunkZ);
    }

    public class_43 method_1806(int chunkX, int chunkZ) {
        this.random.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        FlattenedChunk chunk = new FlattenedChunk(this.world, chunkX, chunkZ);
        if (this.biomes == null || this.biomes.length < 256) {
            this.biomes = new class_153[256];
        }
        for (int b = 0; b < 256; ++b) {
            this.biomes[b] = AetherBiomes.AETHER;
        }
        if (this.temperatures == null || this.temperatures.length < 256) {
            this.temperatures = new double[256];
        }
        for (int t = 0; t < 256; ++t) {
            this.temperatures[t] = 0.5;
        }
        this.buildTerrain(chunkX, chunkZ, chunk, this.biomes, this.temperatures);
        this.buildSurfaces(chunkX, chunkZ, chunk, this.biomes);
        if (!Aether.OLDSTAPI) {
            int y;
            int z;
            int x;
            byte[] tempBlocks = new byte[32768];
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    for (y = 0; y < 128; ++y) {
                        ChunkSection section = chunk.getOrCreateSection(y, false);
                        class_17 block = class_17.field_1937[0];
                        if (section != null) {
                            block = section.getBlockState(x, y & 0xF, z).getBlock();
                        }
                        int blockByte = 0;
                        if (block == AetherBlocks.Holystone) {
                            blockByte = 1;
                        } else if (block != class_17.field_1937[0]) {
                            blockByte = 2;
                        }
                        tempBlocks[(x * 16 + z) * 128 + y] = blockByte;
                    }
                }
            }
            this.cave.method_395((class_51)this, this.world, chunkX, chunkZ, tempBlocks);
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    for (y = 0; y < 128; ++y) {
                        byte newBlockByte = tempBlocks[(x * 16 + z) * 128 + y];
                        ChunkSection section = chunk.getOrCreateSection(y, false);
                        if (section == null) continue;
                        class_17 oldBlock = section.getBlockState(x, y & 0xF, z).getBlock();
                        if (newBlockByte != 0 || oldBlock != AetherBlocks.Holystone) continue;
                        section.setBlockState(x, y & 0xF, z, class_17.field_1937[0].getDefaultState());
                    }
                }
            }
        }
        chunk.method_873();
        return chunk;
    }

    public void method_1803(class_51 chunkSource, int chunkX, int chunkZ) {
        int x;
        int i;
        int z;
        int y;
        int x2;
        int i2;
        int z2;
        int y2;
        int x3;
        class_123.field_375 = true;
        int worldX = chunkX * 16;
        int worldZ = chunkZ * 16;
        class_153 biome = AetherBiomes.AETHER;
        this.random.setSeed(this.world.method_254());
        long seedModifier1 = this.random.nextLong() / 2L * 2L + 1L;
        long seedModifier2 = this.random.nextLong() / 2L * 2L + 1L;
        this.random.setSeed((long)chunkX * seedModifier1 + (long)chunkZ * seedModifier2 ^ this.world.method_254());
        double treeNoiseScale = 0.5;
        if (this.random.nextInt(4) == 0) {
            x3 = worldX + this.random.nextInt(16) + 8;
            y2 = this.random.nextInt(128);
            z2 = worldZ + this.random.nextInt(16) + 8;
            new class_624(class_17.field_1823.field_1915).method_1142(this.world, this.random, x3, y2, z2);
        }
        for (i2 = 0; i2 < 20; ++i2) {
            x2 = worldX + this.random.nextInt(16);
            y = this.random.nextInt(128);
            z = worldZ + this.random.nextInt(16);
            new AetherGenMinable(AetherBlocks.Dirt.field_1915, 32).method_1142(this.world, this.random, x2, y, z);
        }
        for (i2 = 0; i2 < 2; ++i2) {
            x2 = worldX + this.random.nextInt(16) + 8;
            y = this.random.nextInt(128);
            z = worldZ + this.random.nextInt(16) + 8;
            new AetherGenFlowers(AetherBlocks.WhiteFlower.field_1915).method_1142(this.world, this.random, x2, y, z);
        }
        for (i2 = 0; i2 < 2; ++i2) {
            if (this.random.nextInt(2) != 0) continue;
            x2 = worldX + this.random.nextInt(16) + 8;
            y = this.random.nextInt(128);
            z = worldZ + this.random.nextInt(16) + 8;
            new AetherGenFlowers(AetherBlocks.PurpleFlower.field_1915).method_1142(this.world, this.random, x2, y, z);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            x2 = worldX + this.random.nextInt(16);
            y = this.random.nextInt(128);
            z = worldZ + this.random.nextInt(16);
            new AetherGenMinable(AetherBlocks.Icestone.field_1915, 32).method_1142(this.world, this.random, x2, y, z);
        }
        for (i2 = 0; i2 < 20; ++i2) {
            x2 = worldX + this.random.nextInt(16);
            y = this.random.nextInt(128);
            z = worldZ + this.random.nextInt(16);
            new AetherGenMinable(AetherBlocks.AmbrosiumOre.field_1915, 16).method_1142(this.world, this.random, x2, y, z);
        }
        for (i2 = 0; i2 < 15; ++i2) {
            x2 = worldX + this.random.nextInt(16);
            y = this.random.nextInt(64);
            z = worldZ + this.random.nextInt(16);
            new AetherGenMinable(AetherBlocks.ZaniteOre.field_1915, 8).method_1142(this.world, this.random, x2, y, z);
        }
        for (i2 = 0; i2 < 8; ++i2) {
            x2 = worldX + this.random.nextInt(16);
            y = this.random.nextInt(32);
            z = worldZ + this.random.nextInt(16);
            new AetherGenMinable(AetherBlocks.GravititeOre.field_1915, 7).method_1142(this.world, this.random, x2, y, z);
        }
        if (this.random.nextInt(50) == 0) {
            x3 = worldX + this.random.nextInt(16);
            y2 = this.random.nextInt(32) + 96;
            z2 = worldZ + this.random.nextInt(16);
            new AetherGenClouds(AetherBlocks.Aercloud.field_1915, 2, 4, false).method_1142(this.world, this.random, x3, y2, z2);
        }
        if (this.random.nextInt(13) == 0) {
            x3 = worldX + this.random.nextInt(16);
            y2 = this.random.nextInt(64) + 32;
            z2 = worldZ + this.random.nextInt(16);
            new AetherGenClouds(AetherBlocks.Aercloud.field_1915, 1, 8, false).method_1142(this.world, this.random, x3, y2, z2);
        }
        if (this.random.nextInt(7) == 0) {
            x3 = worldX + this.random.nextInt(16);
            y2 = this.random.nextInt(64) + 32;
            z2 = worldZ + this.random.nextInt(16);
            new AetherGenClouds(AetherBlocks.Aercloud.field_1915, 0, 16, false).method_1142(this.world, this.random, x3, y2, z2);
        }
        if (this.random.nextInt(50) == 0) {
            x3 = worldX + this.random.nextInt(16);
            y2 = this.random.nextInt(32);
            z2 = worldZ + this.random.nextInt(16);
            new AetherGenClouds(AetherBlocks.Aercloud.field_1915, 0, 64, true).method_1142(this.world, this.random, x3, y2, z2);
        }
        for (i2 = 0; i2 < 2; ++i2) {
            x2 = worldX + this.random.nextInt(16);
            y = 32 + this.random.nextInt(64);
            z = worldZ + this.random.nextInt(16);
            new AetherGenDungeonBronze(AetherBlocks.LockedDungeonStone.field_1915, AetherBlocks.LockedLightDungeonStone.field_1915, AetherBlocks.DungeonStone.field_1915, AetherBlocks.LightDungeonStone.field_1915, AetherBlocks.Holystone.field_1915, 2, AetherBlocks.Holystone.field_1915, 0, 16, true).method_1142(this.world, this.random, x2, y, z);
        }
        if (this.random.nextInt(500) == 0) {
            x3 = worldX + this.random.nextInt(16);
            y2 = this.random.nextInt(32) + 64;
            z2 = worldZ + this.random.nextInt(16);
            new AetherGenDungeonSilver(AetherBlocks.LockedDungeonStone.field_1915, AetherBlocks.LockedLightDungeonStone.field_1915, AetherBlocks.DungeonStone.field_1915, AetherBlocks.LightDungeonStone.field_1915, AetherBlocks.Holystone.field_1915, 2, AetherBlocks.Holystone.field_1915, 0, AetherBlocks.Pillar.field_1915).method_1142(this.world, this.random, x3, y2, z2);
        }
        if (this.random.nextInt(5) == 0) {
            for (x3 = worldX; x3 < worldX + 16; ++x3) {
                for (int z3 = worldZ; z3 < worldZ + 16; ++z3) {
                    for (y = 0; y < 48; ++y) {
                        if (this.world.method_1776(x3, y, z3) != 0 || this.world.method_1776(x3, y + 1, z3) != AetherBlocks.Grass.field_1915 || this.world.method_1776(x3, y + 2, z3) != 0) continue;
                        new AetherGenQuicksoil(AetherBlocks.Quicksoil.field_1915).method_1142(this.world, this.random, x3, y, z3);
                        y = 128;
                    }
                }
            }
        }
        int treeCount = (int)((this.forestNoise.method_1513((double)worldX * treeNoiseScale, (double)worldZ * treeNoiseScale) / 8.0 + this.random.nextDouble() * 4.0 + 4.0) / 3.0);
        int extraTrees = 0;
        if (this.random.nextInt(10) == 0) {
            ++extraTrees;
        }
        if (biome == class_153.field_878) {
            extraTrees += treeCount + 5;
        }
        if (biome == class_153.field_875) {
            extraTrees += treeCount + 5;
        }
        if (biome == class_153.field_877) {
            extraTrees += treeCount + 2;
        }
        if (biome == class_153.field_881) {
            extraTrees += treeCount + 5;
        }
        if (biome == class_153.field_882) {
            extraTrees -= 20;
        }
        if (biome == class_153.field_885) {
            extraTrees -= 20;
        }
        if (biome == class_153.field_883) {
            extraTrees -= 20;
        }
        extraTrees += treeCount;
        for (i = 0; i < extraTrees; ++i) {
            x = worldX + this.random.nextInt(16) + 8;
            int z4 = worldZ + this.random.nextInt(16) + 8;
            class_239 treeGenerator = this.random.nextInt(100) == 0 ? new AetherGenGoldenOak() : new AetherGenSkyroot();
            treeGenerator.method_1143(1.0, 1.0, 1.0);
            treeGenerator.method_1142(this.world, this.random, x, this.world.method_222(x, z4), z4);
        }
        for (i = 0; i < 50; ++i) {
            x = worldX + this.random.nextInt(16) + 8;
            int y3 = this.random.nextInt(this.random.nextInt(120) + 8);
            int z5 = worldZ + this.random.nextInt(16) + 8;
            new AetherGenLiquids(class_17.field_1822.field_1915).method_1142(this.world, this.random, x, y3, z5);
        }
        class_123.field_375 = false;
    }

    private double[] generateHeightMap(double[] buffer, int xStart, int yStart, int zStart, int xSize, int ySize, int zSize) {
        if (buffer == null) {
            buffer = new double[xSize * ySize * zSize];
        }
        if (this.depthNoiseBuffer == null) {
            this.depthNoiseBuffer = new double[xSize * ySize * zSize];
            this.minLimitPerlinNoiseBuffer = new double[xSize * ySize * zSize];
            this.maxLimitPerlinNoiseBuffer = new double[xSize * ySize * zSize];
            this.scaleNoiseBuffer = new double[xSize * ySize * zSize];
            this.perlinNoiseBuffer = new double[xSize * ySize * zSize];
        }
        double xzScale = 684.412;
        double yScale = 684.412;
        this.scaleNoiseBuffer = this.floatingIslandScale.method_1515(this.scaleNoiseBuffer, xStart, zStart, xSize, zSize, 1.121, 1.121, 0.5);
        this.perlinNoiseBuffer = this.floatingIslandNoise.method_1515(this.perlinNoiseBuffer, xStart, zStart, xSize, zSize, 200.0, 200.0, 0.5);
        this.depthNoiseBuffer = this.perlinNoise1.method_1514(this.depthNoiseBuffer, (double)xStart, (double)yStart, (double)zStart, xSize, ySize, zSize, xzScale / 80.0, yScale / 160.0, xzScale / 80.0);
        this.minLimitPerlinNoiseBuffer = this.minLimitPerlinNoise.method_1514(this.minLimitPerlinNoiseBuffer, (double)xStart, (double)yStart, (double)zStart, xSize, ySize, zSize, xzScale, yScale, xzScale);
        this.maxLimitPerlinNoiseBuffer = this.maxLimitPerlinNoise.method_1514(this.maxLimitPerlinNoiseBuffer, (double)xStart, (double)yStart, (double)zStart, xSize, ySize, zSize, xzScale, yScale, xzScale);
        int index = 0;
        int scaleIndex = 0;
        for (int x = 0; x < xSize; ++x) {
            for (int z = 0; z < zSize; ++z) {
                double floatingIslandFactor;
                double scale = (this.scaleNoiseBuffer[scaleIndex] + 256.0) / 512.0;
                if (scale > 1.0) {
                    scale = 1.0;
                }
                if ((floatingIslandFactor = this.perlinNoiseBuffer[scaleIndex] / 8000.0) < 0.0) {
                    floatingIslandFactor = -floatingIslandFactor * 0.3;
                }
                if ((floatingIslandFactor = floatingIslandFactor * 3.0 - 2.0) > 1.0) {
                    floatingIslandFactor = 1.0;
                }
                floatingIslandFactor /= 8.0;
                floatingIslandFactor = 0.0;
                if (scale < 0.0) {
                    scale = 0.0;
                }
                scale += 0.5;
                floatingIslandFactor = floatingIslandFactor * (double)ySize / 16.0;
                ++scaleIndex;
                double center = (double)ySize / 2.0;
                for (int y = 0; y < ySize; ++y) {
                    double density = 0.0;
                    double yDistanceFromCenter = ((double)y - center) * 8.0 / scale;
                    if (yDistanceFromCenter < 0.0) {
                        yDistanceFromCenter *= -1.0;
                    }
                    double minLimit = this.minLimitPerlinNoiseBuffer[index] / 512.0;
                    double maxLimit = this.maxLimitPerlinNoiseBuffer[index] / 512.0;
                    double depthNoise = (this.depthNoiseBuffer[index] / 10.0 + 1.0) / 2.0;
                    density = depthNoise < 0.0 ? minLimit : (depthNoise > 1.0 ? maxLimit : minLimit + (maxLimit - minLimit) * depthNoise);
                    density -= 8.0;
                    int topFadeStart = 32;
                    if (y > ySize - topFadeStart) {
                        double topFade = (float)(y - (ySize - topFadeStart)) / ((float)topFadeStart - 1.0f);
                        density = density * (1.0 - topFade) + -30.0 * topFade;
                    }
                    if (y < (topFadeStart = 8)) {
                        double bottomFade = (float)(topFadeStart - y) / ((float)topFadeStart - 1.0f);
                        density = density * (1.0 - bottomFade) + -30.0 * bottomFade;
                    }
                    buffer[index] = density;
                    ++index;
                }
            }
        }
        return buffer;
    }

    public boolean method_1804(boolean saveEntities, class_62 display) {
        return true;
    }

    public boolean func_532_a() {
        return false;
    }

    public boolean func_536_b() {
        return true;
    }

    public String method_1808() {
        return "RandomLevelSource";
    }

    public boolean method_1801() {
        return false;
    }

    public boolean method_1805() {
        return true;
    }
}

