/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.aether.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11;
import net.minecraft.class_169;
import net.minecraft.class_240;
import net.minecraft.class_69;

public class ModLoaderPacket
extends class_169 {
    private static final int MAX_DATA_LENGTH = 65535;
    public int modId;
    public int packetType;
    public int[] dataInt = new int[0];
    public float[] dataFloat = new float[0];
    public String[] dataString = new String[0];
    @Environment(value=EnvType.SERVER)
    private static final Map<class_240, class_69> playerMap = new HashMap<class_240, class_69>();

    public void method_806(DataInputStream datainputstream) {
        try {
            this.modId = datainputstream.readInt();
            this.packetType = datainputstream.readInt();
            int i = datainputstream.readInt();
            if (i > 65535) {
                throw new IOException(String.format("Integer data size of %d is higher than the max (%d).", i, 65535));
            }
            this.dataInt = new int[i];
            for (int j = 0; j < i; ++j) {
                this.dataInt[j] = datainputstream.readInt();
            }
            int k = datainputstream.readInt();
            if (k > 65535) {
                throw new IOException(String.format("Float data size of %d is higher than the max (%d).", k, 65535));
            }
            this.dataFloat = new float[k];
            for (int l = 0; l < k; ++l) {
                this.dataFloat[l] = datainputstream.readFloat();
            }
            int i1 = datainputstream.readInt();
            if (i1 > 65535) {
                throw new IOException(String.format("String data size of %d is higher than the max (%d).", i1, 65535));
            }
            this.dataString = new String[i1];
            for (int j1 = 0; j1 < i1; ++j1) {
                int k1 = datainputstream.readInt();
                if (k1 > 65535) {
                    throw new IOException(String.format("String length of %d is higher than the max (%d).", k1, 65535));
                }
                byte[] abyte0 = new byte[k1];
                datainputstream.read(abyte0, 0, k1);
                this.dataString[j1] = new String(abyte0);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_807(DataOutputStream dataoutputstream) {
        try {
            if (this.dataInt != null && this.dataInt.length > 65535) {
                throw new IOException(String.format("Integer data size of %d is higher than the max (%d).", this.dataInt.length, 65535));
            }
            if (this.dataFloat != null && this.dataFloat.length > 65535) {
                throw new IOException(String.format("Float data size of %d is higher than the max (%d).", this.dataFloat.length, 65535));
            }
            if (this.dataString != null && this.dataString.length > 65535) {
                throw new IOException(String.format("String data size of %d is higher than the max (%d).", this.dataString.length, 65535));
            }
            dataoutputstream.writeInt(this.modId);
            dataoutputstream.writeInt(this.packetType);
            if (this.dataInt == null) {
                dataoutputstream.writeInt(0);
            } else {
                dataoutputstream.writeInt(this.dataInt.length);
                for (int j : this.dataInt) {
                    dataoutputstream.writeInt(j);
                }
            }
            if (this.dataFloat == null) {
                dataoutputstream.writeInt(0);
            } else {
                dataoutputstream.writeInt(this.dataFloat.length);
                for (float v : this.dataFloat) {
                    dataoutputstream.writeFloat(v);
                }
            }
            if (this.dataString == null) {
                dataoutputstream.writeInt(0);
            } else {
                dataoutputstream.writeInt(this.dataString.length);
                for (String s : this.dataString) {
                    if (s.length() > 65535) {
                        throw new IOException(String.format("String length of %d is higher than the max (%d).", s.length(), 65535));
                    }
                    dataoutputstream.writeInt(s.length());
                    dataoutputstream.writeBytes(s);
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void method_808(class_240 netHandler) {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            class_69 player = null;
            if (playerMap.containsKey(netHandler)) {
                player = playerMap.get(netHandler);
            } else if (netHandler instanceof class_11) {
                // empty if block
            }
        }
    }

    public int method_798() {
        int i = 1;
        ++i;
        ++i;
        i += this.dataInt != null ? this.dataInt.length * 32 : 0;
        ++i;
        i += this.dataFloat != null ? this.dataFloat.length * 32 : 0;
        ++i;
        if (this.dataString != null) {
            for (String s : this.dataString) {
                ++i;
                i += s.length();
            }
        }
        return i;
    }
}

