/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.retroauth.mixin.client;

import com.matthewperiut.retroauth.profile.GameProfile;
import com.matthewperiut.retroauth.session.SessionData;
import java.net.HttpURLConnection;
import java.net.URL;
import net.minecraft.class_117;
import net.minecraft.class_118;
import net.minecraft.class_169;
import net.minecraft.class_219;
import net.minecraft.class_281;
import net.minecraft.client.Minecraft;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_219.class})
public abstract class ClientNetworkHandlerMixin {
    @Shadow
    private Minecraft field_1972;
    @Shadow
    private class_117 field_1971;

    @Shadow
    public abstract void method_1648(class_169 var1);

    @Redirect(method={"onHandshake"}, at=@At(value="INVOKE", target="Ljava/lang/String;equals(Ljava/lang/Object;)Z"))
    private boolean checkServerId(String serverId, Object offline) {
        return serverId.trim().isEmpty() || serverId.equals(offline) || this.field_1972.field_2809.field_873.trim().isEmpty() || this.field_1972.field_2809.field_873.equals(offline);
    }

    @Inject(method={"onHandshake"}, at={@At(value="NEW", target="java/net/URL")}, cancellable=true)
    private void onJoinServer(class_281 packet, CallbackInfo ci) {
        SessionData session = (SessionData)this.field_1972.field_2809;
        try {
            if (session.getGameProfile() == null || session.getAccessToken() == null) {
                this.field_1971.method_1125("disconnect.loginFailedInfo", new Object[]{"Invalid access token!"});
            }
            this.joinServer(session.getGameProfile(), session.getAccessToken(), packet.field_1130);
            this.method_1648((class_169)new class_118(this.field_1972.field_2809.field_872, 14));
        }
        catch (Exception e) {
            this.field_1971.method_1125("disconnect.loginFailedInfo", new Object[]{e.getMessage()});
        }
        ci.cancel();
    }

    @Unique
    private void joinServer(GameProfile profile, String accessToken, String serverId) throws Exception {
        URL url = new URL("https://sessionserver.mojang.com/session/minecraft/join");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/json");
        String payload = String.format("{\"accessToken\":\"%s\",\"selectedProfile\":\"%s\",\"serverId\":\"%s\"}", accessToken, profile.getId(), serverId);
        connection.getOutputStream().write(payload.getBytes());
        if (connection.getResponseCode() != 204) {
            throw new Exception("Failed to join server: " + connection.getResponseMessage());
        }
    }
}

