/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.retroauth.profile;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Base64;
import java.util.Objects;

public class GameProfile {
    private final String id;
    private final String name;
    private final String textureValue;
    private final String textureSignature;
    private final String capeUrl;
    private final String skinUrl;

    public GameProfile(String id, String name, String textureValue, String textureSignature, String capeUrl, String skinUrl) {
        this.id = id;
        this.name = name;
        this.textureValue = textureValue;
        this.textureSignature = textureSignature;
        this.capeUrl = capeUrl;
        this.skinUrl = skinUrl;
    }

    private static String addDashesToUUID(String uuid32) {
        return uuid32.replaceFirst("([0-9a-fA-F]{8})([0-9a-fA-F]{4})([0-9a-fA-F]{4})([0-9a-fA-F]{4})([0-9a-fA-F]{12})", "$1-$2-$3-$4-$5");
    }

    public String getId() {
        return GameProfile.addDashesToUUID(this.id);
    }

    public String getName() {
        return this.name;
    }

    public String getTextureValue() {
        return this.textureValue;
    }

    public String getTextureSignature() {
        return this.textureSignature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GameProfile that = (GameProfile)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.textureValue, that.textureValue) && Objects.equals(this.textureSignature, that.textureSignature);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.textureValue, this.textureSignature);
    }

    public String toString() {
        return "GameProfile{id='" + this.id + "', name='" + this.name + "', textureValue='" + this.textureValue + "', textureSignature='" + this.textureSignature + "'}";
    }

    public String getModel() {
        JsonObject skin;
        JsonObject textures = this.parseTextureData();
        if (textures != null && textures.has("SKIN") && (skin = textures.getAsJsonObject("SKIN")).has("metadata") && skin.getAsJsonObject("metadata").has("model")) {
            return skin.getAsJsonObject("metadata").get("model").getAsString();
        }
        return "default";
    }

    public String getSkinUrl() {
        if (this.skinUrl != null) {
            return this.skinUrl;
        }
        JsonObject textures = this.parseTextureData();
        if (textures != null && textures.has("SKIN")) {
            return textures.getAsJsonObject("SKIN").get("url").getAsString();
        }
        return null;
    }

    public String getCapeUrl() {
        if (this.capeUrl != null) {
            return this.capeUrl;
        }
        JsonObject textures = this.parseTextureData();
        if (textures != null && textures.has("CAPE")) {
            return textures.getAsJsonObject("CAPE").get("url").getAsString();
        }
        return null;
    }

    private JsonObject parseTextureData() {
        try {
            String decodedData = new String(Base64.getDecoder().decode(this.textureValue));
            JsonObject json = JsonParser.parseString((String)decodedData).getAsJsonObject();
            return json.getAsJsonObject("textures");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

