/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.retroauth.skin;

import com.matthewperiut.retroauth.RetroAuth;
import com.matthewperiut.retroauth.profile.GameProfile;
import com.matthewperiut.retroauth.profile.PlayerProfile;
import com.matthewperiut.retroauth.profile.provider.MineToolsProfileProvider;
import com.matthewperiut.retroauth.profile.provider.MojangProfileProvider;
import com.matthewperiut.retroauth.profile.provider.ProfileProvider;
import com.matthewperiut.retroauth.skin.data.PlayerEntitySkinData;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.client.Minecraft;

public class SkinService {
    public static final String STEVE_TEXTURE = "/assets/retroauth/mob/steve.png";
    public static final String ALEX_TEXTURE = "/assets/retroauth/mob/alex.png";
    private static final SkinService INSTANCE = new SkinService();
    private final ConcurrentMap<String, ReentrantLock> locks = new ConcurrentHashMap<String, ReentrantLock>();
    private final Map<String, PlayerProfile> profiles = new HashMap<String, PlayerProfile>();
    private final List<ProfileProvider> providers = List.of(new MineToolsProfileProvider(), new MojangProfileProvider());

    public static SkinService getInstance() {
        return INSTANCE;
    }

    private void updatePlayer(class_54 player, PlayerProfile playerProfile) {
        PlayerEntitySkinData skinData = (PlayerEntitySkinData)player;
        if (playerProfile == null) {
            RetroAuth.LOGGER.info("Profile not found for player {}, using default skin.", (Object)player.field_528);
            skinData.setTextureModel("default");
        } else {
            skinData.setTextureModel(playerProfile.getTextureModel());
            player.field_1652 = playerProfile.getSkinUrl();
            player.field_1653 = player.field_506 = playerProfile.getCapeUrl();
        }
        ((Minecraft)FabricLoader.getInstance().getGameInstance()).field_2805.method_1156((class_57)player);
    }

    private boolean updatePlayer(class_54 player) {
        if (this.profiles.containsKey(player.field_528)) {
            PlayerProfile profile = this.profiles.get(player.field_528);
            this.updatePlayer(player, profile);
            return true;
        }
        return false;
    }

    private void initOffline(class_54 player) {
        UUID uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + player.field_528).getBytes(StandardCharsets.UTF_8));
        PlayerEntitySkinData skinData = (PlayerEntitySkinData)player;
        skinData.setTextureModel("default");
    }

    public void init(class_54 player) {
        if (this.updatePlayer(player)) {
            return;
        }
        this.initOffline(player);
        new Thread(() -> {
            try {
                this.init(player.field_528);
                this.updatePlayer(player);
            }
            catch (Exception e) {
                RetroAuth.LOGGER.error("Error initializing profile for player {}", (Object)player.field_528, (Object)e);
                this.initOffline(player);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String name) {
        if (this.profiles.containsKey(name)) {
            return;
        }
        ReentrantLock lock = this.locks.computeIfAbsent(name, k -> new ReentrantLock());
        lock.lock();
        try {
            if (this.profiles.containsKey(name)) {
                return;
            }
            for (ProfileProvider provider : this.providers) {
                GameProfile gameProfile;
                try {
                    gameProfile = provider.get(name).get();
                }
                catch (Exception e) {
                    RetroAuth.LOGGER.warn("Profile lookup failed using {} for player {}: {}", new Object[]{provider.getClass().getSimpleName(), name, e.getMessage()});
                    continue;
                }
                try {
                    PlayerProfile playerProfile = new PlayerProfile(UUID.fromString(gameProfile.getId()), gameProfile.getSkinUrl() != null ? gameProfile.getSkinUrl() : STEVE_TEXTURE, gameProfile.getCapeUrl(), gameProfile.getModel() != null ? gameProfile.getModel() : "default");
                    RetroAuth.LOGGER.info("[{}] Downloaded profile: {} ({})", new Object[]{provider.getProviderName(), gameProfile.getName(), gameProfile.getId()});
                    this.profiles.put(name, playerProfile);
                }
                catch (Exception e) {
                    RetroAuth.LOGGER.error("[{}] Failed to map GameProfile to PlayerProfile for player {}: {}", new Object[]{provider.getProviderName(), name, e.getMessage()});
                    continue;
                }
                return;
            }
            RetroAuth.LOGGER.info("No profile found for player {}, using offline fallback.", (Object)name);
            this.profiles.put(name, null);
        }
        finally {
            lock.unlock();
        }
    }
}

