/*
 * Decompiled with CFR 0.152.
 */
package com.github.telvarost.clientsideessentials;

import com.github.telvarost.clientsideessentials.BrightnessRangeEnum;
import com.github.telvarost.clientsideessentials.Config;
import com.github.telvarost.clientsideessentials.ModOptions;

public class PostProcess {
    public static final double DEFAULT_GAMMA_D = 2.2;
    public static final double DEFAULT_GAMMA_INV = 0.45454545454545453;
    public static PostProcess instance = new PostProcess();

    private float getCalcGamma() {
        if (BrightnessRangeEnum.SMALL == Config.config.BRIGHTNESS_CONFIG.BRIGHTNESS_RANGE) {
            return (1.0f - ModOptions.brightness) * 1.2f + 1.6f;
        }
        if (BrightnessRangeEnum.EXTRA_LARGE == Config.config.BRIGHTNESS_CONFIG.BRIGHTNESS_RANGE) {
            return (1.0f - ModOptions.brightness) * 4.2f + 0.1f;
        }
        return (1.0f - ModOptions.brightness) * 2.4f + 1.0f;
    }

    private float readFloat(String s) {
        return s.equals("true") ? 1.0f : (s.equals("false") ? 0.0f : Float.parseFloat(s));
    }

    public int red(int r, int g, int b) {
        if ((double)this.getCalcGamma() != 2.2) {
            r = (int)(Math.pow(Math.pow((double)r / 255.0, this.getCalcGamma()), 0.45454545454545453) * 255.0);
        }
        return r;
    }

    public int green(int r, int g, int b) {
        if ((double)this.getCalcGamma() != 2.2) {
            g = (int)(Math.pow(Math.pow((double)g / 255.0, this.getCalcGamma()), 0.45454545454545453) * 255.0);
        }
        return g;
    }

    public int blue(int r, int g, int b) {
        if ((double)this.getCalcGamma() != 2.2) {
            b = (int)(Math.pow(Math.pow((double)b / 255.0, this.getCalcGamma()), 0.45454545454545453) * 255.0);
        }
        return b;
    }

    public float red(float r, float g, float b) {
        if (r != 0.0f && (double)this.getCalcGamma() != 2.2) {
            r = (float)Math.pow(Math.pow(r, this.getCalcGamma()), 0.45454545454545453);
        }
        return r;
    }

    public float green(float r, float g, float b) {
        if (g != 0.0f && (double)this.getCalcGamma() != 2.2) {
            g = (float)Math.pow(Math.pow(g, this.getCalcGamma()), 0.45454545454545453);
        }
        return g;
    }

    public float blue(float r, float g, float b) {
        if (b != 0.0f && (double)this.getCalcGamma() != 2.2) {
            b = (float)Math.pow(Math.pow(b, this.getCalcGamma()), 0.45454545454545453);
        }
        return b;
    }
}

