/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.aether.entity.living;

import com.matthewperiut.accessoryapi.api.BossLivingEntity;
import com.matthewperiut.aether.achievement.AetherAchievements;
import com.matthewperiut.aether.block.AetherBlocks;
import com.matthewperiut.aether.entity.AetherEntities;
import com.matthewperiut.aether.entity.living.EntityDungeonMob;
import com.matthewperiut.aether.entity.projectile.EntityHomeShot;
import com.matthewperiut.aether.item.AetherItems;
import com.matthewperiut.aether.util.NameGen;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_127;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_187;
import net.minecraft.class_189;
import net.minecraft.class_202;
import net.minecraft.class_25;
import net.minecraft.class_31;
import net.minecraft.class_419;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_69;
import net.minecraft.class_8;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.modificationstation.stationapi.api.server.entity.MobSpawnDataProvider;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.SideUtil;

public class EntityValkyrie
extends EntityDungeonMob
implements BossLivingEntity,
MobSpawnDataProvider {
    public boolean isSwinging;
    public boolean boss;
    public boolean duel;
    public boolean hasDungeon;
    public int teleTimer;
    public int angerLevel;
    public int timeLeft;
    public int chatTime;
    public int dungeonX;
    public int dungeonY;
    public int dungeonZ;
    public int dungeonEntranceZ;
    public double safeX;
    public double safeY;
    public double safeZ;
    public float sinage;
    public double lastMotionY;
    public String bossName;
    boolean isBoss = false;
    public int areaOfEffect = 50;

    public EntityValkyrie(class_18 world) {
        super(world);
        this.method_1321(0.8f, 1.6f);
        this.field_1019 = "aether:stationapi/textures/mobs/valkyrie.png";
        this.teleTimer = this.field_1644.nextInt(250);
        this.field_1036 = 50;
        this.field_1033 = 0.5f;
        this.timeLeft = 1200;
        this.attackStrength = 7;
        this.safeX = this.field_1600;
        this.safeY = this.field_1601;
        this.safeZ = this.field_1602;
    }

    public EntityValkyrie(class_18 world, double x, double y, double z, boolean flag) {
        super(world);
        this.method_1321(0.8f, 1.6f);
        this.bossName = NameGen.gen();
        this.field_1019 = "aether:stationapi/textures/mobs/valkyrie.png";
        if (flag) {
            this.field_1019 = "aether:stationapi/textures/mobs/valkyrie2.png";
            this.field_1036 = 500;
            this.boss = true;
        } else {
            this.field_1036 = 50;
        }
        this.teleTimer = this.field_1644.nextInt(250);
        this.field_1033 = 0.5f;
        this.timeLeft = 1200;
        this.attackStrength = 7;
        this.safeX = this.field_1600 = x;
        this.safeY = this.field_1601 = y;
        this.safeZ = this.field_1602 = z;
        this.hasDungeon = false;
    }

    public void method_1389(float f) {
    }

    public void method_1370() {
        this.lastMotionY = this.field_1604;
        super.method_1370();
        if (!this.field_1623 && this.field_662 != null && this.lastMotionY >= 0.0 && this.field_1604 < 0.0 && this.method_1351(this.field_662) <= 16.0f && this.method_928(this.field_662)) {
            double a = this.field_662.field_1600 - this.field_1600;
            double b = this.field_662.field_1602 - this.field_1602;
            double angle = Math.atan2(a, b);
            this.field_1603 = Math.sin(angle) * 0.25;
            this.field_1605 = Math.cos(angle) * 0.25;
        }
        if (!this.field_1623 && !this.method_932() && Math.abs(this.field_1604 - this.lastMotionY) > 0.07 && Math.abs(this.field_1604 - this.lastMotionY) < 0.09) {
            this.field_1604 += (double)0.055f;
            if (this.field_1604 < (double)-0.275f) {
                this.field_1604 = -0.275f;
            }
        }
        float f = this.field_1033 = this.field_662 == null ? 0.5f : 1.0f;
        if (this.field_1596.field_213 <= 0 && (this.field_662 != null || this.angerLevel > 0)) {
            this.angerLevel = 0;
            this.field_662 = null;
        }
        if (this.isSwinging) {
            this.field_1027 += 0.15f;
            this.field_1035 += 0.15f;
            if (this.field_1027 > 1.0f || this.field_1035 > 1.0f) {
                this.isSwinging = false;
                this.field_1027 = 0.0f;
                this.field_1035 = 0.0f;
            }
        }
        this.sinage = !this.field_1623 ? (this.sinage += 0.75f) : (this.sinage += 0.15f);
        if (this.sinage > 6.283186f) {
            this.sinage -= 6.283186f;
        }
        if (!this.otherDimension()) {
            --this.timeLeft;
            if (this.timeLeft <= 0) {
                this.field_1630 = true;
                this.method_919();
            }
        }
    }

    public boolean otherDimension() {
        return true;
    }

    public void teleport(double x, double y, double z, int rad) {
        int a = this.field_1644.nextInt(rad + 1);
        int b = this.field_1644.nextInt(rad / 2);
        int c = rad - a;
        int newX = (int)Math.floor((x += (double)(a *= this.field_1644.nextInt(2) * 2 - 1)) - 0.5);
        int newY = (int)Math.floor((y += (double)(b *= this.field_1644.nextInt(2) * 2 - 1)) - 0.5);
        int newZ = (int)Math.floor((z += (double)(c *= this.field_1644.nextInt(2) * 2 - 1)) - 0.5);
        boolean flag = false;
        for (int q = 0; q < 32 && !flag; ++q) {
            int i = newX + (this.field_1644.nextInt(rad / 2) - this.field_1644.nextInt(rad / 2));
            int j = newY + (this.field_1644.nextInt(rad / 2) - this.field_1644.nextInt(rad / 2));
            int k = newZ + (this.field_1644.nextInt(rad / 2) - this.field_1644.nextInt(rad / 2));
            if (j > 124 || j < 5 || !this.isAirySpace(i, j, k) || !this.isAirySpace(i, j + 1, k) || this.isAirySpace(i, j - 1, k) || this.hasDungeon && (i <= this.dungeonX || i >= this.dungeonX + 20 || j <= this.dungeonY || j >= this.dungeonY + 12 || k <= this.dungeonZ || k >= this.dungeonZ + 20)) continue;
            newX = i;
            newY = j;
            newZ = k;
            flag = true;
        }
        if (!flag) {
            this.teleFail();
        } else {
            this.method_919();
            this.method_1340((double)newX + 0.5, (double)newY + 0.5, (double)newZ + 0.5);
            this.field_1603 = 0.0;
            this.field_1604 = 0.0;
            this.field_1605 = 0.0;
            this.field_1029 = 0.0f;
            this.field_1060 = 0.0f;
            this.field_1031 = false;
            this.field_1607 = 0.0f;
            this.field_1606 = 0.0f;
            this.method_635(null);
            this.field_1012 = this.field_1644.nextFloat() * 360.0f;
            this.method_919();
            this.teleTimer = this.field_1644.nextInt(40);
        }
    }

    public boolean isAirySpace(int x, int y, int z) {
        int p = this.field_1596.method_1776(x, y, z);
        return p == 0 || class_17.field_1937[p].method_1624(this.field_1596, x, y, z) == null;
    }

    public boolean method_940() {
        return !this.boss;
    }

    public boolean method_1323(class_54 entityplayer) {
        this.method_924((class_57)entityplayer, 180.0f, 180.0f);
        if (!this.boss) {
            if (this.timeLeft >= 1200) {
                class_31 itemstack = entityplayer.method_502();
                if (itemstack != null && itemstack.field_753 == AetherItems.VictoryMedal.field_461 && itemstack.field_751 >= 0) {
                    if (itemstack.field_751 >= 10) {
                        this.chatItUp("Umm... that's a nice pile of medallions you have there...");
                    } else if (itemstack.field_751 >= 5) {
                        this.chatItUp("That's pretty impressive, but you won't defeat me.");
                    } else {
                        this.chatItUp("You think you're a tough guy, eh? Well, bring it on!");
                    }
                } else {
                    int pokey = this.field_1644.nextInt(3);
                    if (pokey == 2) {
                        this.chatItUp("What's that? You want to fight? Aww, what a cute little human.");
                    } else if (pokey == 1) {
                        this.chatItUp("You're not thinking of fighting a big, strong Valkyrie are you?");
                    } else {
                        this.chatItUp("I don't think you should bother me, you could get really hurt.");
                    }
                }
            }
        } else if (this.duel) {
            this.chatItUp("If you wish to challenge me, strike at any time.");
        } else if (!this.duel) {
            class_31 itemstack = entityplayer.method_502();
            if (itemstack != null && itemstack.field_753 == AetherItems.VictoryMedal.field_461 && itemstack.field_751 >= 10) {
                itemstack.field_751 -= 10;
                if (itemstack.field_751 <= 0) {
                    itemstack.method_700(entityplayer);
                    entityplayer.method_503();
                    this.chatTime = 0;
                    this.chatItUp("Very well, attack me when you wish to begin.");
                    this.duel = true;
                }
            } else {
                this.chatItUp("Show me 10 victory medals, and I will fight you.");
            }
        }
        return true;
    }

    private void chatItUp(String s) {
        if (this.chatTime <= 0) {
            this.chatLine(s);
            this.chatTime = 60;
        }
    }

    public void chatLine(String s) {
        SideUtil.run(() -> this.chatLineClient(s), () -> this.chatLineServer(s));
    }

    @Environment(value=EnvType.CLIENT)
    public void chatLineClient(String s) {
        Minecraft mc = (Minecraft)FabricLoader.getInstance().getGameInstance();
        mc.field_2820.method_1949(s);
    }

    @Environment(value=EnvType.SERVER)
    public void chatLineServer(String s) {
        MinecraftServer mc = (MinecraftServer)FabricLoader.getInstance().getGameInstance();
        List playersNearby = this.field_1596.method_175(class_54.class, class_25.method_87((double)(this.field_1600 - (double)this.areaOfEffect), (double)(this.field_1601 - (double)this.areaOfEffect), (double)(this.field_1602 - (double)this.areaOfEffect), (double)(this.field_1600 + (double)this.areaOfEffect), (double)(this.field_1601 + (double)this.areaOfEffect), (double)(this.field_1602 + (double)this.areaOfEffect)));
        for (class_54 player : playersNearby) {
            ((class_69)player).method_490(s);
        }
    }

    public void makeHomeShot(int shots, class_127 ep) {
        for (int i = 0; i < shots; ++i) {
            EntityHomeShot e1 = new EntityHomeShot(this.field_1596, this.field_1600 - this.field_1603 / 2.0, this.field_1601, this.field_1602 - this.field_1605 / 2.0, ep);
            this.field_1596.method_210((class_57)e1);
        }
    }

    protected void method_933() {
        if (this.boss) {
            this.method_1327(new class_31(AetherItems.Key, 1, 1), 0.0f);
            this.method_1339(class_124.field_380.field_461, 1);
        } else {
            this.method_1339(AetherItems.VictoryMedal.field_461, 1);
        }
    }

    public void method_910() {
        super.method_910();
        ++this.teleTimer;
        if (this.teleTimer >= 450) {
            if (this.field_662 != null) {
                if (this.boss && this.field_1623 && this.field_1644.nextInt(2) == 0 && this.field_662 != null && this.field_662 instanceof class_127) {
                    this.makeHomeShot(1, (class_127)this.field_662);
                    this.teleTimer = -100;
                } else {
                    this.teleport(this.field_662.field_1600, this.field_662.field_1601, this.field_662.field_1602, 7);
                }
            } else if (this.field_1623 && !this.boss) {
                this.teleport(this.field_1600, this.field_1601, this.field_1602, 12 + this.field_1644.nextInt(12));
            } else {
                this.teleport(this.safeX, this.safeY, this.safeZ, 6);
            }
        } else if (this.teleTimer >= 446 || !(this.field_1601 <= 0.0) && !(this.field_1601 <= this.safeY - 16.0)) {
            if (this.teleTimer % 5 == 0 && this.field_662 != null && !this.method_928(this.field_662)) {
                this.teleTimer += 100;
            }
        } else {
            this.teleTimer = 446;
        }
        if (this.field_1623 && this.teleTimer % 10 == 0 && !this.boss) {
            this.safeX = this.field_1600;
            this.safeY = this.field_1601;
            this.safeZ = this.field_1602;
        }
        if (this.field_662 != null && this.field_662.field_1630) {
            this.field_662 = null;
            if (this.boss) {
                this.unlockDoor();
                this.isBoss = false;
            }
            this.angerLevel = 0;
        }
        if (this.chatTime > 0) {
            --this.chatTime;
        }
    }

    public void swingArm() {
        if (!this.isSwinging) {
            this.isSwinging = true;
            this.field_1027 = 0.0f;
            this.field_1035 = 0.0f;
        }
    }

    public void teleFail() {
        this.teleTimer -= this.field_1644.nextInt(40) + 40;
        if (this.field_1601 <= 0.0) {
            this.teleTimer = 446;
        }
    }

    @Override
    public boolean method_935() {
        int k;
        int j;
        int i = class_189.method_645((double)this.field_1600);
        return this.field_1596.method_252(i, j = class_189.method_645((double)this.field_1610.field_130), k = class_189.method_645((double)this.field_1602)) > 8 && this.field_1596.method_168(this.field_1610) && this.field_1596.method_190((class_57)this, this.field_1610).size() == 0 && !this.field_1596.method_218(this.field_1610);
    }

    @Override
    public void method_1368(class_8 nbttagcompound) {
        super.method_1368(nbttagcompound);
        nbttagcompound.method_1020("Anger", (short)this.angerLevel);
        nbttagcompound.method_1020("TeleTimer", (short)this.teleTimer);
        nbttagcompound.method_1020("TimeLeft", (short)this.timeLeft);
        nbttagcompound.method_1021("Boss", this.boss);
        nbttagcompound.method_1021("Duel", this.duel);
        nbttagcompound.method_1015("DungeonX", this.dungeonX);
        nbttagcompound.method_1015("DungeonY", this.dungeonY);
        nbttagcompound.method_1015("DungeonZ", this.dungeonZ);
        nbttagcompound.method_1015("DungeonEntranceZ", this.dungeonEntranceZ);
        nbttagcompound.method_1017("SafePos", (class_187)this.method_1329(new double[]{this.safeX, this.safeY, this.safeZ}));
        nbttagcompound.method_1021("IsCurrentBoss", this.isBoss);
        if (this.isBoss && this.bossName != null && !this.bossName.isEmpty()) {
            nbttagcompound.method_1019("BossName", this.bossName);
        }
    }

    @Override
    public void method_1363(class_8 nbttagcompound) {
        super.method_1363(nbttagcompound);
        this.angerLevel = nbttagcompound.method_1026("Anger");
        this.teleTimer = nbttagcompound.method_1026("TeleTimer");
        this.timeLeft = nbttagcompound.method_1026("TimeLeft");
        this.duel = nbttagcompound.method_1035("Duel");
        this.boss = nbttagcompound.method_1035("Boss");
        this.dungeonX = nbttagcompound.method_1027("DungeonX");
        this.dungeonY = nbttagcompound.method_1027("DungeonY");
        this.dungeonZ = nbttagcompound.method_1027("DungeonZ");
        this.dungeonEntranceZ = nbttagcompound.method_1027("DungeonEntranceZ");
        if (this.boss) {
            this.field_1019 = "aether:stationapi/textures/mobs/valkyrie2.png";
        }
        class_202 nbttaglist = nbttagcompound.method_1034("SafePos");
        this.safeX = ((class_419)nbttaglist.method_1396((int)0)).field_1680;
        this.safeY = ((class_419)nbttaglist.method_1396((int)1)).field_1680;
        this.safeZ = ((class_419)nbttaglist.method_1396((int)2)).field_1680;
        if (nbttagcompound.method_1035("IsCurrentBoss")) {
            this.isBoss = true;
        }
        if (this.isBoss) {
            this.bossName = nbttagcompound.method_1031("BossName");
            if (this.bossName == null) {
                this.bossName = NameGen.gen();
            }
        }
    }

    @Override
    protected class_57 method_638() {
        return !this.otherDimension() || this.field_1596.field_213 > 0 && (!this.boss || this.duel) && this.angerLevel > 0 ? super.method_638() : null;
    }

    @Override
    public boolean method_1355(class_57 entity, int i) {
        if (entity instanceof class_54 && this.field_1596.field_213 > 0) {
            int pokey;
            if (this.boss && (!this.duel || this.field_1596.field_213 <= 0)) {
                this.method_919();
                int pokey2 = this.field_1644.nextInt(2);
                if (pokey2 == 2) {
                    this.chatItUp("Sorry, I don't fight with weaklings.");
                } else {
                    this.chatItUp("Try defeating some weaker valkyries first.");
                }
                return false;
            }
            if (this.boss) {
                if (this.field_662 == null) {
                    this.isBoss = true;
                    this.chatTime = 0;
                    this.chatItUp("This will be your final battle!");
                } else {
                    this.teleTimer += 60;
                }
            } else if (this.field_662 == null) {
                this.chatTime = 0;
                pokey = this.field_1644.nextInt(3);
                if (pokey == 2) {
                    this.chatItUp("I'm not going easy on you!");
                } else if (pokey == 1) {
                    this.chatItUp("You're gonna regret that!");
                } else {
                    this.chatItUp("Now you're in for it!");
                }
            } else {
                this.teleTimer -= 10;
            }
            this.becomeAngryAt(entity);
            boolean flag = super.method_1355(entity, i);
            if (flag && this.field_1036 <= 0) {
                pokey = this.field_1644.nextInt(3);
                this.field_1630 = true;
                if (this.boss) {
                    this.field_1630 = false;
                    this.unlockDoor();
                    this.unlockTreasure();
                    this.chatItUp("You are truly... a mighty warrior...");
                    this.isBoss = false;
                } else if (pokey == 2) {
                    this.chatItUp("Alright, alright! You win!");
                } else if (pokey == 1) {
                    this.chatItUp("Okay, I give up! Geez!");
                } else {
                    this.chatItUp("Oww! Fine, here's your medal...");
                }
                this.method_919();
            }
            return flag;
        }
        this.teleport(this.field_1600, this.field_1601, this.field_1602, 8);
        this.field_1647 = 0;
        return false;
    }

    @Override
    protected void method_637(class_57 entity, float f) {
        if (this.field_1042 <= 0 && f < 2.75f && entity.field_1610.field_133 > this.field_1610.field_130 && entity.field_1610.field_130 < this.field_1610.field_133) {
            this.field_1042 = 20;
            this.swingArm();
            entity.method_1355((class_57)this, this.attackStrength);
            if (entity != null && this.field_662 != null && entity == this.field_662 && entity instanceof class_127) {
                class_127 e1 = (class_127)entity;
                if (e1.field_1036 <= 0) {
                    this.field_662 = null;
                    this.angerLevel = 0;
                    int pokey = this.field_1644.nextInt(3);
                    this.chatTime = 0;
                    if (this.boss) {
                        this.chatItUp("As expected of a human.");
                        this.unlockDoor();
                        this.isBoss = false;
                    } else if (pokey == 2) {
                        this.chatItUp("You want a medallion? Try being less pathetic.");
                    } else if (pokey == 1 && e1 instanceof class_54) {
                        class_54 ep = (class_54)e1;
                        String s = ep.field_528;
                        this.chatItUp("Maybe some day, " + s + "... maybe some day.");
                    } else {
                        this.chatItUp("Humans aren't nearly as cute when they're dead.");
                    }
                }
            }
        }
    }

    private void becomeAngryAt(class_57 entity) {
        this.field_662 = entity;
        this.angerLevel = 200 + this.field_1644.nextInt(200);
        if (this.boss) {
            for (int k = this.dungeonZ + 2; k < this.dungeonZ + 23; k += 7) {
                if (this.field_1596.method_1776(this.dungeonX - 1, this.dungeonY, k) != 0) continue;
                this.dungeonEntranceZ = k;
                this.field_1596.method_154(this.dungeonX - 1, this.dungeonY, k, AetherBlocks.LockedDungeonStone.field_1915, 1);
                this.field_1596.method_154(this.dungeonX - 1, this.dungeonY, k + 1, AetherBlocks.LockedDungeonStone.field_1915, 1);
                this.field_1596.method_154(this.dungeonX - 1, this.dungeonY + 1, k + 1, AetherBlocks.LockedDungeonStone.field_1915, 1);
                this.field_1596.method_154(this.dungeonX - 1, this.dungeonY + 1, k, AetherBlocks.LockedDungeonStone.field_1915, 1);
                return;
            }
        }
    }

    private void unlockDoor() {
        this.field_1596.method_200(this.dungeonX - 1, this.dungeonY, this.dungeonEntranceZ, 0);
        this.field_1596.method_200(this.dungeonX - 1, this.dungeonY, this.dungeonEntranceZ + 1, 0);
        this.field_1596.method_200(this.dungeonX - 1, this.dungeonY + 1, this.dungeonEntranceZ + 1, 0);
        this.field_1596.method_200(this.dungeonX - 1, this.dungeonY + 1, this.dungeonEntranceZ, 0);
    }

    private void unlockTreasure() {
        this.field_1596.method_154(this.dungeonX + 16, this.dungeonY + 1, this.dungeonZ + 9, class_17.field_1913.field_1915, 3);
        this.field_1596.method_154(this.dungeonX + 17, this.dungeonY + 1, this.dungeonZ + 9, class_17.field_1913.field_1915, 2);
        this.field_1596.method_154(this.dungeonX + 16, this.dungeonY + 1, this.dungeonZ + 10, class_17.field_1913.field_1915, 3);
        this.field_1596.method_154(this.dungeonX + 17, this.dungeonY + 1, this.dungeonZ + 10, class_17.field_1913.field_1915, 2);
        List playersNearby = this.field_1596.method_175(class_54.class, class_25.method_87((double)(this.field_1600 - (double)this.areaOfEffect), (double)(this.field_1601 - (double)this.areaOfEffect), (double)(this.field_1602 - (double)this.areaOfEffect), (double)(this.field_1600 + (double)this.areaOfEffect), (double)(this.field_1601 + (double)this.areaOfEffect), (double)(this.field_1602 + (double)this.areaOfEffect)));
        for (class_54 player : playersNearby) {
            AetherAchievements.giveAchievement(AetherAchievements.defeatSilver, player);
        }
        for (int x = this.dungeonX - 26; x < this.dungeonX + 29; ++x) {
            for (int y = this.dungeonY - 1; y < this.dungeonY + 22; ++y) {
                for (int z = this.dungeonZ - 5; z < this.dungeonZ + 25; ++z) {
                    int id = this.field_1596.method_1776(x, y, z);
                    if (id == AetherBlocks.LockedDungeonStone.field_1915) {
                        this.field_1596.method_154(x, y, z, AetherBlocks.DungeonStone.field_1915, this.field_1596.method_1778(x, y, z));
                    }
                    if (id == AetherBlocks.Trap.field_1915) {
                        this.field_1596.method_154(x, y, z, AetherBlocks.DungeonStone.field_1915, this.field_1596.method_1778(x, y, z));
                    }
                    if (id != AetherBlocks.LockedLightDungeonStone.field_1915) continue;
                    this.field_1596.method_154(x, y, z, AetherBlocks.LightDungeonStone.field_1915, this.field_1596.method_1778(x, y, z));
                }
            }
        }
    }

    public void setDungeon(int i, int j, int k) {
        this.hasDungeon = true;
        this.dungeonX = i;
        this.dungeonY = j;
        this.dungeonZ = k;
    }

    public void setBoss(boolean boss) {
        this.isBoss = boss;
    }

    public boolean isBoss() {
        return this.isBoss;
    }

    public int getHP() {
        return this.field_1036;
    }

    public int getMaxHP() {
        return 500;
    }

    public String getName() {
        return this.bossName + ", the Valkyrie Queen";
    }

    public Identifier getHandlerIdentifier() {
        return AetherEntities.MOD_ID.id("Valkyrie");
    }
}

