/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.aether.entity.projectile;

import com.matthewperiut.aether.item.AetherItems;
import net.minecraft.class_127;
import net.minecraft.class_18;
import net.minecraft.class_411;
import net.minecraft.class_511;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.server.entity.HasTrackingParameters;
import net.modificationstation.stationapi.api.server.entity.MobSpawnDataProvider;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.TriState;

@HasTrackingParameters(trackingDistance=50, sendVelocity=TriState.TRUE, updatePeriod=1)
public class EntityHomeShot
extends class_511
implements MobSpawnDataProvider {
    public float[] sinage;
    public class_127 target;
    public boolean firstRun;
    public int life;
    public int lifeSpan;
    private static final double topSpeed = 0.125;
    private static final float sponge = 57.295773f;

    public EntityHomeShot(class_18 world) {
        super(world);
        this.field_1019 = "aether:stationapi/textures/mobs/electroball.png";
        this.life = this.lifeSpan = 200;
        this.method_1321(0.7f, 0.7f);
        this.firstRun = true;
        this.sinage = new float[3];
        this.field_1615 = true;
        for (int i = 0; i < 3; ++i) {
            this.sinage[i] = this.field_1644.nextFloat() * 6.0f;
        }
    }

    public EntityHomeShot(class_18 world, double x, double y, double z, class_127 ep) {
        super(world);
        this.field_1019 = "aether:stationapi/textures/mobs/electroball.png";
        this.life = this.lifeSpan = 200;
        this.method_1321(0.7f, 0.7f);
        this.method_1340(x, y, z);
        this.target = ep;
        this.sinage = new float[3];
        this.field_1615 = true;
        for (int i = 0; i < 3; ++i) {
            this.sinage[i] = this.field_1644.nextFloat() * 6.0f;
        }
    }

    public void method_1370() {
        super.method_1370();
        --this.life;
        if (this.firstRun && this.target == null) {
            this.target = (class_127)this.findPlayerToAttack();
            this.firstRun = false;
        }
        if (this.target != null && this.target.method_1318()) {
            if (this.life <= 0) {
                class_411 thunder = new class_411(this.field_1596, this.field_1600, this.field_1601, this.field_1602);
                this.field_1596.method_210((class_57)thunder);
                this.field_1630 = true;
            } else {
                this.updateAnims();
                this.faceIt();
                this.moveIt((class_57)this.target, 0.02);
            }
        } else {
            this.field_1630 = true;
        }
    }

    public void moveIt(class_57 e1, double sped) {
        double angle1 = this.field_1606 / 57.295773f;
        this.field_1603 -= Math.sin(angle1) * sped;
        this.field_1605 += Math.cos(angle1) * sped;
        double a = e1.field_1601 - 0.75;
        this.field_1604 = a < this.field_1610.field_130 - 0.5 ? (this.field_1604 -= sped / 2.0) : (a > this.field_1610.field_130 + 0.5 ? (this.field_1604 += sped / 2.0) : (this.field_1604 += (a - this.field_1610.field_130) * (sped / 2.0)));
        if (this.field_1623) {
            this.field_1623 = false;
            this.field_1604 = 0.1f;
        }
    }

    public void faceIt() {
        this.method_924((class_57)this.target, 10.0f, 10.0f);
    }

    public void updateAnims() {
        for (int i = 0; i < 3; ++i) {
            float[] var10000 = this.sinage;
            int n = i;
            var10000[n] = var10000[n] + (0.3f + (float)i * 0.13f);
            if (!(this.sinage[i] > 6.283186f)) continue;
            var10000 = this.sinage;
            int n2 = i;
            var10000[n2] = var10000[n2] - 6.283186f;
        }
    }

    public void method_1368(class_8 nbttagcompound) {
        super.method_1368(nbttagcompound);
        nbttagcompound.method_1020("LifeLeft", (short)this.life);
    }

    public void method_1363(class_8 nbttagcompound) {
        super.method_1363(nbttagcompound);
        this.life = nbttagcompound.method_1026("LifeLeft");
    }

    public void checkOverLimit() {
        double a = this.target.field_1600 - this.field_1600;
        double b = this.target.field_1601 - this.field_1601;
        double c = this.target.field_1602 - this.field_1602;
        double d = Math.sqrt(a * a + b * b + c * c);
        if (d > 0.125) {
            double e = 0.125 / d;
            this.field_1603 *= e;
            this.field_1604 *= e;
            this.field_1605 *= e;
        }
    }

    public class_57 findPlayerToAttack() {
        class_54 entityplayer = this.field_1596.method_186((class_57)this, 16.0);
        return entityplayer != null && this.method_928((class_57)entityplayer) ? entityplayer : null;
    }

    public void method_1353(class_57 entity) {
        boolean flag;
        super.method_1353(entity);
        if (entity != null && this.target != null && entity == this.target && (flag = entity.method_1355((class_57)this, 1))) {
            this.moveIt(entity, -0.1);
        }
    }

    public boolean method_1355(class_57 entity, int i) {
        if (entity != null) {
            this.moveIt(entity, -0.15 - (double)i / 8.0);
            return true;
        }
        return false;
    }

    public Identifier getHandlerIdentifier() {
        return AetherItems.MOD_ID.id("HomeShot");
    }
}

