/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.retrocommands.command.server;

import com.matthewperiut.retrocommands.api.Command;
import com.matthewperiut.retrocommands.util.ServerUtil;
import com.matthewperiut.retrocommands.util.SharedCommandSource;
import java.util.ArrayList;
import java.util.Set;

public class Whitelist
implements Command {
    @Override
    public void command(SharedCommandSource commandSource, String[] parameters) {
        this.processWhitelistCommand(commandSource.getName(), ServerUtil.appendEnd(0, parameters), commandSource);
    }

    @Override
    public String name() {
        return "whitelist";
    }

    @Override
    public void manual(SharedCommandSource commandSource) {
        commandSource.sendFeedback("Usage: /whitelist {on/off/list/add/remove/reload} {player}");
    }

    private void processWhitelistCommand(String string, String string2, SharedCommandSource arg) {
        String[] var4 = string2.split(" ");
        if (var4.length >= 2) {
            String var5 = var4[1].toLowerCase();
            if ("on".equals(var5)) {
                ServerUtil.sendFeedbackAndLog(string, "Turned on white-listing");
                ServerUtil.getServer().field_2840.method_1250("white-list", true);
            } else if ("off".equals(var5)) {
                ServerUtil.sendFeedbackAndLog(string, "Turned off white-listing");
                ServerUtil.getServer().field_2840.method_1250("white-list", false);
            } else if ("list".equals(var5)) {
                Set var6 = ServerUtil.getServer().field_2842.method_574();
                Object var7 = "";
                for (String var9 : var6) {
                    var7 = (String)var7 + var9 + " ";
                }
                arg.sendFeedback("White-listed players: " + (String)var7);
            } else if ("add".equals(var5) && var4.length == 3) {
                String var10 = var4[2].toLowerCase();
                ServerUtil.getServer().field_2842.method_590(var10);
                ServerUtil.sendFeedbackAndLog(string, "Added " + var10 + " to white-list");
            } else if ("remove".equals(var5) && var4.length == 3) {
                String var10 = var4[2].toLowerCase();
                ServerUtil.getServer().field_2842.method_592(var10);
                ServerUtil.sendFeedbackAndLog(string, "Removed " + var10 + " from white-list");
            } else if ("reload".equals(var5)) {
                ServerUtil.getServer().field_2842.method_577();
                ServerUtil.sendFeedbackAndLog(string, "Reloaded white-list from file");
            }
        } else {
            this.manual(arg);
        }
    }

    @Override
    public boolean disableInSingleplayer() {
        return true;
    }

    @Override
    public String[] suggestion(SharedCommandSource source, int parameterNum, String currentInput, String totalInput) {
        if (parameterNum == 1) {
            String[] options = new String[]{"add", "on", "list", "reload", "remove", "off"};
            ArrayList<String> output = new ArrayList<String>();
            for (String option : options) {
                if (!option.startsWith(currentInput)) continue;
                output.add(option.substring(currentInput.length()));
            }
            return output.toArray(new String[0]);
        }
        return new String[0];
    }
}

