/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.retrocommands.command.vanilla;

import com.matthewperiut.retrocommands.api.Command;
import com.matthewperiut.retrocommands.util.SharedCommandSource;
import java.util.ArrayList;
import net.minecraft.class_54;

public class Time
implements Command {
    @Override
    public void command(SharedCommandSource commandSource, String[] parameters) {
        class_54 player = commandSource.getPlayer();
        if (player == null) {
            return;
        }
        if (parameters.length > 1) {
            if (parameters[1].equals("set")) {
                long additional_time = -1L;
                try {
                    additional_time = Integer.parseInt(parameters[2]);
                }
                catch (NumberFormatException e) {
                    switch (parameters[2]) {
                        case "day": {
                            additional_time = 1000L;
                            break;
                        }
                        case "noon": {
                            additional_time = 6000L;
                            break;
                        }
                        case "sunset": {
                            additional_time = 12000L;
                            break;
                        }
                        case "night": {
                            additional_time = 13000L;
                            break;
                        }
                        case "midnight": {
                            additional_time = 18000L;
                            break;
                        }
                        case "sunrise": {
                            additional_time = 23000L;
                            break;
                        }
                        default: {
                            commandSource.sendFeedback("Time is not properly formatted");
                            return;
                        }
                    }
                }
                long time = player.field_1596.method_256();
                long left_over = time % 24000L;
                player.field_1596.method_159(time + (additional_time - left_over));
                commandSource.sendFeedback("Time set to " + additional_time);
                return;
            }
            if (parameters[1].equals("get")) {
                commandSource.sendFeedback("Time is " + String.valueOf(player.field_1596.method_256()));
                commandSource.sendFeedback("Days: " + String.valueOf(player.field_1596.method_256()));
                return;
            }
            if (parameters[1].equals("add")) {
                try {
                    long additional_time = Integer.parseInt(parameters[2]);
                    player.field_1596.method_159(player.field_1596.method_256() + additional_time);
                    commandSource.sendFeedback("You added " + additional_time + " to the time");
                }
                catch (NumberFormatException e) {
                    commandSource.sendFeedback("Cannot add a non-number amount of time");
                }
                return;
            }
        }
        this.manual(commandSource);
    }

    @Override
    public String name() {
        return "time";
    }

    @Override
    public void manual(SharedCommandSource commandSource) {
        commandSource.sendFeedback("Usage: /time set {worldTime}");
        commandSource.sendFeedback("Usage: /time add {time}");
        commandSource.sendFeedback("Info: sets the time of day");
        commandSource.sendFeedback("worldTime can be an integer usually between 0 and 24000 or keyword");
        commandSource.sendFeedback("preset keywords are day, noon, sunset, night, midnight, sunrise");
    }

    @Override
    public String[] suggestion(SharedCommandSource source, int parameterNum, String currentInput, String totalInput) {
        if (parameterNum == 1) {
            String[] options = new String[]{"set"};
            ArrayList<String> output = new ArrayList<String>();
            for (String option : options) {
                if (!option.startsWith(currentInput)) continue;
                output.add(option.substring(currentInput.length()));
            }
            return output.toArray(new String[0]);
        }
        if (parameterNum == 2 && totalInput.contains("set")) {
            String[] options = new String[]{"day", "noon", "sunset", "night", "midnight", "sunrise"};
            ArrayList<String> output = new ArrayList<String>();
            for (String option : options) {
                if (!option.startsWith(currentInput)) continue;
                output.add(option.substring(currentInput.length()));
            }
            return output.toArray(new String[0]);
        }
        return new String[0];
    }
}

