/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.retrocommands.util;

import com.matthewperiut.retrocommands.RetroCommands;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.modificationstation.stationapi.api.registry.ItemRegistry;
import net.modificationstation.stationapi.api.util.Identifier;

public class ParameterSuggestUtil {
    public static String[] suggestItemIdentifier(String currentInput) {
        if (!FabricLoader.getInstance().isModLoaded("station-registry-api-v0")) {
            return new String[0];
        }
        boolean autofillingModId = !currentInput.contains(":");
        String modId = "";
        if (!autofillingModId) {
            modId = currentInput.split(":")[0];
        }
        HashSet<Object> outputs = new HashSet<Object>();
        for (Identifier id : ItemRegistry.INSTANCE.getIds()) {
            String[] segments;
            if (autofillingModId) {
                if (!id.namespace.toString().startsWith(currentInput)) continue;
                outputs.add(id.namespace.toString().substring(currentInput.length()) + ":");
                continue;
            }
            if (!id.namespace.toString().equals(modId) || (segments = currentInput.split(":")).length <= 1 || !id.path.startsWith(segments[1])) continue;
            outputs.add(id.path.substring(segments[1].length()));
        }
        return outputs.toArray(new String[0]);
    }

    public static String[] suggestPlayerName(String currentInput) {
        return ParameterSuggestUtil.suggestPlayerName(currentInput, "");
    }

    public static String[] suggestPlayerName(String currentInput, String remove) {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT && RetroCommands.player_names != null) {
            ArrayList<String> playerNames = new ArrayList<String>(Arrays.asList(RetroCommands.player_names));
            if (!remove.isEmpty()) {
                playerNames.removeIf(name -> name.equals(remove));
            }
            return (String[])playerNames.stream().filter(a -> a.startsWith(currentInput)).map(b -> b.substring(currentInput.length())).toArray(String[]::new);
        }
        return new String[0];
    }
}

