/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.retrocommands.util;

import com.matthewperiut.retrocommands.RetroCommands;
import com.matthewperiut.retrocommands.api.Command;
import com.matthewperiut.retrocommands.command.extra.Clock;
import com.matthewperiut.retrocommands.command.extra.God;
import com.matthewperiut.retrocommands.command.extra.Hat;
import com.matthewperiut.retrocommands.command.extra.Heal;
import com.matthewperiut.retrocommands.command.extra.Id;
import com.matthewperiut.retrocommands.command.extra.Mobs;
import com.matthewperiut.retrocommands.command.extra.Mods;
import com.matthewperiut.retrocommands.command.extra.Ride;
import com.matthewperiut.retrocommands.command.extra.ToggleDownfall;
import com.matthewperiut.retrocommands.command.extra.Warp;
import com.matthewperiut.retrocommands.command.extra.WhoAmI;
import com.matthewperiut.retrocommands.command.optional.Gamemode;
import com.matthewperiut.retrocommands.command.optional.ReloadCryonicConfig;
import com.matthewperiut.retrocommands.command.server.Ban;
import com.matthewperiut.retrocommands.command.server.BanIp;
import com.matthewperiut.retrocommands.command.server.Deop;
import com.matthewperiut.retrocommands.command.server.Kick;
import com.matthewperiut.retrocommands.command.server.List;
import com.matthewperiut.retrocommands.command.server.Op;
import com.matthewperiut.retrocommands.command.server.Pardon;
import com.matthewperiut.retrocommands.command.server.PardonIp;
import com.matthewperiut.retrocommands.command.server.Save;
import com.matthewperiut.retrocommands.command.server.Say;
import com.matthewperiut.retrocommands.command.server.Stop;
import com.matthewperiut.retrocommands.command.server.Tpa;
import com.matthewperiut.retrocommands.command.server.Whitelist;
import com.matthewperiut.retrocommands.command.vanilla.Clear;
import com.matthewperiut.retrocommands.command.vanilla.Give;
import com.matthewperiut.retrocommands.command.vanilla.Help;
import com.matthewperiut.retrocommands.command.vanilla.Kill;
import com.matthewperiut.retrocommands.command.vanilla.KillAll;
import com.matthewperiut.retrocommands.command.vanilla.Summon;
import com.matthewperiut.retrocommands.command.vanilla.Teleport;
import com.matthewperiut.retrocommands.command.vanilla.Time;
import com.matthewperiut.retrocommands.util.ConfigUtil;
import com.matthewperiut.retrocommands.util.SharedCommandSource;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;

public class RetroChatUtil {
    public static ArrayList<Command> commands = new ArrayList();

    public static void addDefaultCommands() {
        commands.add(new Help());
        commands.add(new Mods());
        commands.add(new Kick());
        commands.add(new Ban());
        commands.add(new Pardon());
        commands.add(new BanIp());
        commands.add(new PardonIp());
        commands.add(new Op());
        commands.add(new Deop());
        commands.add(new Stop());
        commands.add(new Save());
        commands.add(new List());
        commands.add(new Say());
        commands.add(new Whitelist());
        commands.add(new Clear());
        if (RetroCommands.bhCreative) {
            commands.add(new Gamemode());
        }
        commands.add(new Give());
        commands.add(new God());
        commands.add(new Heal());
        commands.add(new Id());
        commands.add(new Mobs());
        commands.add(new Summon());
        commands.add(new Tpa());
        commands.add(new Teleport());
        commands.add(new Time());
        commands.add(new Clock());
        commands.add(new ToggleDownfall());
        commands.add(new Ride());
        commands.add(new Hat());
        commands.add(new KillAll());
        commands.add(new Kill());
        commands.add(new Warp());
        commands.add(new WhoAmI());
        if (RetroCommands.cryConfig) {
            commands.add(new ReloadCryonicConfig());
        }
        for (Command c : commands) {
            if (c.disableInSingleplayer() && FabricLoader.getInstance().getEnvironmentType() != EnvType.SERVER) continue;
            Help.addHelpTip("/" + c.name(), c.needsPermissions());
        }
    }

    public static boolean handleCommand(SharedCommandSource commandSource, String command, boolean operator) {
        String wanted;
        String[] segments = command.split(" ");
        boolean help = segments[0].equals("help") && segments.length > 1;
        boolean page = help && Character.isDigit(segments[1].charAt(0));
        String string = wanted = help ? segments[1] : segments[0];
        if (RetroCommands.cryConfig) {
            ConfigUtil.refreshDisabledCommands();
            if (RetroCommands.disabled_commands.contains(command)) {
                commandSource.sendFeedback("Command '" + segments[0] + "' not found. Try /help");
                return false;
            }
        }
        for (Command c : commands) {
            if (c.name() == null || !operator && c.needsPermissions() || !c.name().equals(wanted) || c.disableInSingleplayer() && FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) continue;
            if (help) {
                c.manual(commandSource);
                return true;
            }
            try {
                c.command(commandSource, segments);
                return true;
            }
            catch (Exception e) {
                commandSource.sendFeedback("Error: " + e.getMessage());
                return false;
            }
        }
        if (segments[0].equals("help")) {
            for (Command c : commands) {
                if (!c.name().equals("help")) continue;
                try {
                    c.command(commandSource, segments);
                    return true;
                }
                catch (Exception e) {
                    commandSource.sendFeedback("Error: " + e.getMessage());
                    return false;
                }
            }
        }
        commandSource.sendFeedback("Command '" + segments[0] + "' not found. Try /help");
        return false;
    }
}

