/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.retrocommands.util;

import com.matthewperiut.retrocommands.mixin.access.ServerPlayerPacketHandlerAccessor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11;
import net.minecraft.class_39;
import net.minecraft.class_54;
import net.minecraft.client.Minecraft;

public class SharedCommandSource {
    private final Object actualSource;

    public SharedCommandSource(Object source) {
        this.actualSource = source;
    }

    public void sendFeedback(String feedback) {
        EnvType side = FabricLoader.getInstance().getEnvironmentType();
        switch (side) {
            case CLIENT: {
                this.sendClientFeedback("\u00a77" + feedback);
                break;
            }
            case SERVER: {
                this.sendServerFeedback(feedback);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown side " + String.valueOf(side) + "!");
            }
        }
    }

    public String getName() {
        Object object = this.actualSource;
        if (object instanceof class_54) {
            class_54 player = (class_54)object;
            return player.field_528;
        }
        EnvType side = FabricLoader.getInstance().getEnvironmentType();
        if (side == EnvType.CLIENT) {
            return this.getNameClient();
        }
        if (side == EnvType.SERVER) {
            return this.getNameServer();
        }
        return "unknown";
    }

    public class_54 getPlayer() {
        Object object = this.actualSource;
        if (object instanceof class_54) {
            class_54 player = (class_54)object;
            return player;
        }
        EnvType side = FabricLoader.getInstance().getEnvironmentType();
        if (side == EnvType.CLIENT) {
            return this.getPlayerClient();
        }
        if (side == EnvType.SERVER) {
            return this.getPlayerServer();
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    private class_54 getPlayerClient() {
        return ((Minecraft)FabricLoader.getInstance().getGameInstance()).field_2806;
    }

    @Environment(value=EnvType.SERVER)
    private class_54 getPlayerServer() {
        Object object = this.actualSource;
        if (object instanceof class_11) {
            class_11 playerPacketHandler = (class_11)object;
            return ((ServerPlayerPacketHandlerAccessor)playerPacketHandler).getServerPlayer();
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    private String getNameClient() {
        return "client";
    }

    @Environment(value=EnvType.SERVER)
    private String getNameServer() {
        Object object = this.actualSource;
        if (object instanceof class_39) {
            class_39 cmdSrc = (class_39)object;
            return cmdSrc.method_1410();
        }
        return "unknown";
    }

    @Environment(value=EnvType.CLIENT)
    private void sendClientFeedback(String feedback) {
        ((Minecraft)FabricLoader.getInstance().getGameInstance()).field_2820.method_1949(feedback);
    }

    @Environment(value=EnvType.SERVER)
    private void sendServerFeedback(String feedback) {
        ((class_39)this.actualSource).method_1409(feedback);
    }

    public boolean isClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }
}

