/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.accessoryapi.command;

import com.matthewperiut.accessoryapi.api.PlayerExtraHP;
import com.matthewperiut.retrocommands.api.Command;
import com.matthewperiut.retrocommands.util.SharedCommandSource;
import java.util.ArrayList;
import net.minecraft.class_54;

public class HeartsCommand
implements Command {
    public void command(SharedCommandSource commandSource, String[] parameters) {
        class_54 player = commandSource.getPlayer();
        if (player == null) {
            commandSource.sendFeedback("This command can only be run by a player");
            return;
        }
        if (parameters.length > 2) {
            switch (parameters[1]) {
                case "add": {
                    commandSource.sendFeedback("Added " + (float)Integer.parseInt(parameters[2]) / 2.0f + " Hearts");
                    ((PlayerExtraHP)player).addExtraHP(Integer.parseInt(parameters[2]));
                    break;
                }
                case "remove": {
                    commandSource.sendFeedback("Removed " + (float)Integer.parseInt(parameters[2]) / 2.0f + " Hearts");
                    ((PlayerExtraHP)player).addExtraHP(-Integer.parseInt(parameters[2]));
                    break;
                }
                default: {
                    this.manual(commandSource);
                    break;
                }
            }
        } else if (parameters.length > 1 && parameters[1].equals("count")) {
            commandSource.sendFeedback("You have " + (10.0f + (float)((PlayerExtraHP)player).getExtraHP() / 2.0f) + " Hearts");
        } else {
            this.manual(commandSource);
        }
    }

    public String name() {
        return "hearts";
    }

    public void manual(SharedCommandSource commandSource) {
        commandSource.sendFeedback("Usage: /hearts {add/remove} {halfHearts}");
        commandSource.sendFeedback("       /hearts {count}");
        commandSource.sendFeedback("Info: Changes the total number of hearts a player has");
    }

    public String[] suggestion(SharedCommandSource source, int parameterNum, String currentInput, String totalInput) {
        if (parameterNum == 1) {
            String[] options = new String[]{"add", "count", "remove"};
            ArrayList<String> output = new ArrayList<String>();
            for (String option : options) {
                if (!option.startsWith(currentInput)) continue;
                output.add(option.substring(currentInput.length()));
            }
            return output.toArray(new String[0]);
        }
        return super.suggestion(source, parameterNum, currentInput, totalInput);
    }
}

