/*
 * Decompiled with CFR 0.152.
 */
package net.glasslauncher.mods.networking;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.glasslauncher.mods.networking.GlassNetworking;
import net.glasslauncher.mods.networking.mixin.accessor.NbtCompoundAccessor;
import net.minecraft.class_169;
import net.minecraft.class_187;
import net.minecraft.class_240;
import net.minecraft.class_8;
import org.jetbrains.annotations.ApiStatus;

public class GlassPacket
extends class_169 {
    private String modId;
    private String packetId;
    private class_8 nbt;
    public static final ArrayList<String> LOGGED_INVALID_IDS = new ArrayList<String>(){

        @Override
        public boolean remove(Object o) {
            throw new RuntimeException("Don't try to remove from the invalid ids list!");
        }

        @Override
        public String remove(int index) {
            throw new RuntimeException("Don't try to remove from the invalid ids list!");
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            throw new RuntimeException("Don't try to remove from the invalid ids list!");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new RuntimeException("Don't try to remove from the invalid ids list!");
        }

        @Override
        public boolean removeIf(Predicate<? super String> filter) {
            throw new RuntimeException("Don't try to remove from the invalid ids list!");
        }
    };
    private int length;

    public <T extends GlassPacket> GlassPacket(String modId, String packetId, class_8 nbt) {
        this.modId = modId;
        this.packetId = packetId;
        this.nbt = nbt;
    }

    @ApiStatus.Internal
    public GlassPacket() {
    }

    public void method_806(DataInputStream stream) {
        this.nbt = new class_8();
        ((NbtCompoundAccessor)this.nbt).invokeRead(stream);
        this.packetId = this.nbt.method_1031("glassnetworking:packetId");
        this.modId = this.nbt.method_1031("glassnetworking:modId");
    }

    public void method_807(DataOutputStream stream) {
        this.nbt.method_1019("glassnetworking:packetId", this.packetId);
        this.nbt.method_1019("glassnetworking:modId", this.modId);
        this.length = GlassNetworking.writeAndGetNbtLength((class_187)this.nbt, stream);
    }

    public void method_808(class_240 networkHandler) {
        BiConsumer<GlassPacket, class_240> packetHandler = GlassNetworking.PACKET_HANDLERS.get(this.getFullId());
        if (packetHandler != null) {
            packetHandler.accept(this, networkHandler);
        } else if (!LOGGED_INVALID_IDS.contains(this.getFullId())) {
            GlassNetworking.LOGGER.warn("Got packet {} which has no handler! Suppressing future warnings.", (Object)this.getFullId());
            LOGGED_INVALID_IDS.add(this.getFullId());
        }
    }

    public int method_798() {
        return this.length;
    }

    public String getFullId() {
        return this.modId + ":" + this.packetId;
    }

    public String getModId() {
        return this.modId;
    }

    public String getPacketId() {
        return this.packetId;
    }

    public class_8 getNbt() {
        return this.nbt;
    }
}

