/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.retroauth.profile.provider;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.matthewperiut.retroauth.profile.GameProfile;
import com.matthewperiut.retroauth.profile.provider.ProfileProvider;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

public class MineToolsProfileProvider
implements ProfileProvider {
    private static final String UUID_ENDPOINT = "https://api.minetools.eu/uuid/";
    private static final String PROFILE_ENDPOINT = "https://api.minetools.eu/profile/";

    @Override
    public Future<GameProfile> get(String username) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                JsonObject capeObj;
                JsonObject skinObj;
                String uuidUrl = UUID_ENDPOINT + username;
                JsonObject basicProfileJson = this.readJsonFromUrl(uuidUrl);
                if (basicProfileJson == null || !basicProfileJson.has("status")) {
                    System.out.println("No valid response from " + uuidUrl);
                    return null;
                }
                String status = basicProfileJson.get("status").getAsString();
                if (!"OK".equalsIgnoreCase(status)) {
                    System.out.println("Status not OK for " + username + ": " + status);
                    return null;
                }
                String uuid = basicProfileJson.get("id").getAsString();
                String name = basicProfileJson.get("name").getAsString();
                String textureUrl = PROFILE_ENDPOINT + uuid;
                JsonObject detailJson = this.readJsonFromUrl(textureUrl);
                if (detailJson == null || !detailJson.has("raw")) {
                    System.out.println("No valid response from " + textureUrl);
                    return new GameProfile(uuid, name, null, null, null, null);
                }
                JsonObject raw = detailJson.getAsJsonObject("raw");
                if (!raw.has("properties")) {
                    return new GameProfile(uuid, name, null, null, null, null);
                }
                JsonArray properties = raw.getAsJsonArray("properties");
                if (properties.size() == 0) {
                    return new GameProfile(uuid, name, null, null, null, null);
                }
                JsonObject textureProperty = properties.get(0).getAsJsonObject();
                String textureValue = textureProperty.get("value").getAsString();
                String textureSignature = textureProperty.get("signature").getAsString();
                JsonObject decoded = detailJson.getAsJsonObject("decoded");
                JsonObject textures = decoded.getAsJsonObject("textures");
                String skinUrl = null;
                if (textures.has("SKIN") && (skinObj = textures.getAsJsonObject("SKIN")).has("url")) {
                    skinUrl = skinObj.get("url").getAsString();
                }
                String capeUrl = null;
                if (textures.has("CAPE") && (capeObj = textures.getAsJsonObject("CAPE")).has("url")) {
                    capeUrl = capeObj.get("url").getAsString();
                }
                return new GameProfile(uuid, name, textureValue, textureSignature, capeUrl, skinUrl);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject readJsonFromUrl(String urlString) {
        HttpURLConnection conn = null;
        BufferedReader reader = null;
        try {
            String line;
            URL url = new URL(urlString);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("User-Agent", "MineToolsProfileProvider/1.0");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            if (conn.getResponseCode() != 200) {
                JsonObject jsonObject = null;
                return jsonObject;
            }
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder responseBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                responseBuilder.append(line);
            }
            JsonObject jsonObject = JsonParser.parseString((String)responseBuilder.toString()).getAsJsonObject();
            return jsonObject;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JsonObject jsonObject = null;
            return jsonObject;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    @Override
    public String getProviderName() {
        return "MineToolsAPI";
    }
}

