/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.retroauth.profile.provider;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.matthewperiut.retroauth.profile.GameProfile;
import com.matthewperiut.retroauth.profile.provider.ProfileProvider;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

public class MojangProfileProvider
implements ProfileProvider {
    @Override
    public Future<GameProfile> get(String username) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String profileUrl = "https://api.mojang.com/users/profiles/minecraft/" + username;
                JsonObject basicProfile = this.readJsonFromUrl(profileUrl);
                if (basicProfile == null || !basicProfile.has("id")) {
                    return null;
                }
                String uuid = basicProfile.get("id").getAsString();
                String name = basicProfile.get("name").getAsString();
                String sessionUrl = "https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false";
                JsonObject detailedProfile = this.readJsonFromUrl(sessionUrl);
                if (detailedProfile == null) {
                    return null;
                }
                JsonArray properties = detailedProfile.getAsJsonArray("properties");
                if (properties.size() == 0) {
                    return new GameProfile(uuid, name, null, null, null, null);
                }
                JsonObject textureProperty = properties.get(0).getAsJsonObject();
                String textureValue = textureProperty.get("value").getAsString();
                String textureSignature = textureProperty.get("signature").getAsString();
                return new GameProfile(uuid, name, textureValue, textureSignature, null, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject readJsonFromUrl(String urlString) {
        HttpURLConnection conn = null;
        BufferedReader reader = null;
        try {
            String line;
            URL url = new URL(urlString);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("User-Agent", "MojangFixStation/1.0");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            if (conn.getResponseCode() != 200) {
                JsonObject jsonObject = null;
                return jsonObject;
            }
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder responseBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                responseBuilder.append(line);
            }
            JsonObject jsonObject = JsonParser.parseString((String)responseBuilder.toString()).getAsJsonObject();
            return jsonObject;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JsonObject jsonObject = null;
            return jsonObject;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    @Override
    public String getProviderName() {
        return "MojangAPI";
    }
}

