/*
 * Decompiled with CFR 0.152.
 */
package io.github.viciscat.mixin;

import com.google.common.primitives.Floats;
import io.github.viciscat.mixin.ReloadScreenManagerAccessor;
import java.awt.Color;
import java.text.NumberFormat;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import net.minecraft.class_32;
import net.minecraft.class_67;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.client.resource.ReloadScreenManager;
import net.modificationstation.stationapi.api.resource.ResourceReload;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(targets={"net.modificationstation.stationapi.api.client.resource.ReloadScreen"})
public abstract class ReloadScreenMixin
extends class_32 {
    @Shadow(remap=false)
    private boolean exceptionThrown;
    @Shadow(remap=false)
    private boolean finished;
    @Shadow(remap=false)
    private Exception exception;
    @Shadow(remap=false)
    @Final
    private Runnable done;
    @Shadow(remap=false)
    @Final
    private class_32 parent;
    @Shadow(remap=false)
    private float progress;
    @Shadow
    @Final
    private class_67 tessellator;
    @Unique
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance();

    @Shadow
    protected abstract void method_1932(int var1, int var2, int var3, int var4, int var5);

    public void method_118(int mouseX, int mouseY, float delta) {
        Optional reload;
        super.method_118(mouseX, mouseY, delta);
        if (this.parent == null) {
            this.renderEarly();
        } else {
            this.renderNormal(delta);
        }
        this.progress = Floats.constrainToRange((float)(this.progress * 0.95f + (this.isReloadStarted() && (reload = ReloadScreenManager.getCurrentReload()).isPresent() ? ((ResourceReload)reload.orElse(null)).getProgress() : 0.0f) * 0.05f), (float)0.0f, (float)1.0f);
        if (Float.isNaN(this.progress)) {
            this.progress = 0.0f;
        }
        if (!this.exceptionThrown && !this.finished && ReloadScreenManager.isReloadComplete()) {
            try {
                ReloadScreenManager.getCurrentReload().stream().peek(ResourceReload::throwException);
                this.finished = true;
            }
            catch (CompletionException e) {
                this.exceptionThrown = true;
                this.exception = e;
                StationAPI.LOGGER.error("An exception occurred during resource loading", (Throwable)e);
            }
        }
        if (this.finished) {
            ReloadScreenManagerAccessor.onFinish();
            this.done.run();
        }
    }

    @Unique
    private void renderEarly() {
        GL11.glBindTexture((int)3553, (int)this.field_151.field_2814.method_1100("/title/mojang.png"));
        this.method_1932(0, 0, this.field_152, this.field_153, -1);
        this.drawMojangLogoQuad((this.field_152 - 256) / 2, (this.field_153 - 256) / 2);
        GL11.glEnable((int)3042);
        this.renderText(Color.BLACK, false);
        GL11.glDisable((int)3042);
    }

    @Unique
    private void drawMojangLogoQuad(int i, int j) {
        float f = 0.00390625f;
        float f2 = 0.00390625f;
        this.tessellator.method_1695();
        this.tessellator.method_1688((double)i, (double)(j + 256), 0.0, 0.0, (double)(256.0f * f2));
        this.tessellator.method_1688((double)(i + 256), (double)(j + 256), 0.0, (double)(256.0f * f), (double)(256.0f * f2));
        this.tessellator.method_1688((double)(i + 256), (double)j, 0.0, (double)(256.0f * f), 0.0);
        this.tessellator.method_1688((double)i, (double)j, 0.0, 0.0, 0.0);
        this.tessellator.method_1685();
    }

    @Unique
    private void renderNormal(float delta) {
        this.parent.method_118(-1, -1, delta);
        this.method_1933(0, 0, this.field_152, this.field_153, -1072689136, -804253680);
        this.renderText(Color.WHITE, true);
    }

    @Unique
    private void renderText(Color textColor, boolean shadow) {
        if (this.exceptionThrown) {
            this.field_156.method_1905("Oh noes! An error occurred, check your logs.", 0, 0, textColor.getRGB(), shadow);
        } else {
            this.field_156.method_1905("Loading resources...", 0, 0, textColor.getRGB(), shadow);
        }
        List<String> locations = ReloadScreenManagerAccessor.getLocations();
        String s = locations.isEmpty() ? "Doing the do" : locations.get(locations.size() - 1);
        this.field_156.method_1905(s, 5, this.field_153 - 10, textColor.getRGB(), shadow);
        String text = NUMBER_FORMAT.format(this.progress * 100.0f) + "%";
        int textRendererWidth = this.field_156.method_1901(text);
        this.field_156.method_1905(text, this.field_152 - textRendererWidth - 5, this.field_153 - 10, textColor.getRGB(), shadow);
    }

    @Overwrite(remap=false)
    public boolean isReloadStarted() {
        return true;
    }

    static {
        NUMBER_FORMAT.setMinimumFractionDigits(2);
        NUMBER_FORMAT.setMaximumFractionDigits(2);
    }
}

