/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.modmenu.config.option;

import java.util.Locale;
import net.danygames2014.modmenu.config.option.ConfigOption;
import net.danygames2014.modmenu.config.option.ConfigOptionStorage;
import net.danygames2014.modmenu.util.TranslationUtil;
import net.minecraft.class_300;

public class EnumConfigOption<E extends Enum<E>>
implements ConfigOption {
    private final String key;
    private final String translationKey;
    private final Class<E> enumClass;
    private final E defaultValue;

    public EnumConfigOption(String key, E defaultValue) {
        ConfigOptionStorage.setEnum(key, defaultValue);
        this.key = key;
        this.translationKey = TranslationUtil.translationKeyOf("option", key);
        this.enumClass = ((Enum)defaultValue).getDeclaringClass();
        this.defaultValue = defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public E getValue() {
        return ConfigOptionStorage.getEnum(this.key, this.enumClass);
    }

    public void setValue(E value) {
        ConfigOptionStorage.setEnum(this.key, value);
    }

    public void cycleValue() {
        ConfigOptionStorage.cycleEnum(this.key, this.enumClass);
    }

    public void cycleValue(int amount) {
        ConfigOptionStorage.cycleEnum(this.key, this.enumClass, amount);
    }

    public E getDefaultValue() {
        return this.defaultValue;
    }

    private static <E extends Enum<E>> String getValueText(EnumConfigOption<E> option, E value) {
        return class_300.method_992().method_993(option.translationKey + "." + value.name().toLowerCase(Locale.ROOT));
    }

    @Override
    public String getValueLabel() {
        return TranslationUtil.translateOptionLabel(class_300.method_992().method_993(this.translationKey), EnumConfigOption.getValueText(this, this.getValue()));
    }

    @Override
    public void click() {
        this.cycleValue();
    }
}

