/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.modmenu.gui;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.danygames2014.modmenu.ModMenu;
import net.danygames2014.modmenu.config.ModMenuConfig;
import net.danygames2014.modmenu.config.ModMenuConfigManager;
import net.danygames2014.modmenu.gui.ConfirmChatLinkScreen;
import net.danygames2014.modmenu.gui.widget.Controller;
import net.danygames2014.modmenu.gui.widget.DescriptionListWidgetModMenu;
import net.danygames2014.modmenu.gui.widget.ModListWidgetModMenu;
import net.danygames2014.modmenu.gui.widget.TextFieldAccess;
import net.danygames2014.modmenu.gui.widget.TexturedButtonWidget;
import net.danygames2014.modmenu.gui.widget.entries.ModListEntry;
import net.danygames2014.modmenu.util.DrawingUtil;
import net.danygames2014.modmenu.util.ScreenUtil;
import net.danygames2014.modmenu.util.TranslationUtil;
import net.danygames2014.modmenu.util.mod.Mod;
import net.danygames2014.modmenu.util.mod.ModBadgeRenderer;
import net.minecraft.class_181;
import net.minecraft.class_300;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_583;
import net.minecraft.class_92;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;

public class ModsScreen
extends class_32
implements Controller {
    private static final String FILTERS_BUTTON_LOCATION = "/assets/modmenu/textures/gui/filters_button.png";
    private static final String CONFIGURE_BUTTON_LOCATION = "/assets/modmenu/textures/gui/configure_button.png";
    private static final int SEARCH_BOX = 0;
    private static final int DESCRIPTION_LIST = 1;
    private static final int WEBSITE = 2;
    private static final int ISSUES = 3;
    private static final int FILTERS = 4;
    private static final int SORTING = 5;
    private static final int LIBRARIES = 6;
    private static final int MODS_FOLDER = 7;
    private static final int DONE = 8;
    public static final int MODS_LIST_CONFIRM_ID_OFFSET = 10;
    private static final String TOGGLE_FILTER_OPTIONS = class_300.method_992().method_993("modmenu.toggleFilterOptions");
    private static final String CONFIGURE = class_300.method_992().method_993("modmenu.configure");
    private static final Logger LOGGER = LogManager.getLogger((String)"Mod Menu | ModsScreen");
    private static final class_92 itemRenderer = new class_92();
    private class_181 searchBox;
    private DescriptionListWidgetModMenu descriptionListWidget;
    private final String title;
    private final class_32 previousScreen;
    private ModListWidgetModMenu modList;
    private ModListEntry selected;
    private ModBadgeRenderer modBadgeRenderer;
    private float scrollPercent = 0.0f;
    private boolean init = false;
    private boolean filterOptionsShown = false;
    private int paneY;
    private static final int RIGHT_PANE_Y = 48;
    private int paneWidth;
    private int rightPaneX;
    private int searchBoxX;
    private int filtersX;
    private int filtersWidth;
    private int searchRowWidth;
    public final Set<String> showModChildren = new HashSet<String>();
    private int mouseX;
    private int mouseY;
    private List<String> tooltip;
    public final Map<String, Boolean> modHasConfigScreen = new HashMap<String, Boolean>();
    public final Map<String, Throwable> modScreenErrors = new HashMap<String, Throwable>();

    public ModsScreen(class_32 previousScreen) {
        this.title = class_300.method_992().method_993("modmenu.title");
        this.previousScreen = previousScreen;
    }

    @Override
    public void setValue(String value) {
        this.modList.filter(value, false);
    }

    public void method_131() {
        super.method_131();
        if (!this.modList.isMouseInList(this.mouseX, this.mouseY) && this.descriptionListWidget.isMouseInList(this.mouseX, this.mouseY)) {
            this.descriptionListWidget.handleMouse();
        }
    }

    public void method_122() {
        this.searchBox.method_1882();
    }

    public void method_119() {
        this.paneY = ModMenuConfig.CONFIG_MODE.getValue() ? 48 : 67;
        this.paneWidth = this.field_152 / 2 - 8;
        this.rightPaneX = this.field_152 - this.paneWidth;
        int filtersButtonSize = ModMenuConfig.CONFIG_MODE.getValue() ? 0 : 22;
        int searchWidthMax = this.paneWidth - 32 - filtersButtonSize;
        int searchBoxWidth = ModMenuConfig.CONFIG_MODE.getValue() ? Math.min(200, searchWidthMax) : searchWidthMax;
        this.searchBoxX = this.paneWidth / 2 - searchBoxWidth / 2 - filtersButtonSize / 2;
        this.searchBox = new class_181((class_32)this, this.field_156, this.searchBoxX, 22, searchBoxWidth, 20, "");
        ((TextFieldAccess)this.searchBox).setController(this);
        for (Mod mod : ModMenu.MODS.values()) {
            String id = mod.getId();
            if (this.modHasConfigScreen.containsKey(id)) continue;
            try {
                class_32 configScreen = ModMenu.getConfigScreen(id, this);
                this.modHasConfigScreen.put(id, configScreen != null);
            }
            catch (NoClassDefFoundError e) {
                LOGGER.warn("The '" + id + "' mod config screen is not available because " + e.getLocalizedMessage() + " is missing.");
                this.modScreenErrors.put(id, e);
                this.modHasConfigScreen.put(id, false);
            }
            catch (Throwable e) {
                LOGGER.error("Error from mod '" + id + "'", e);
                this.modScreenErrors.put(id, e);
                this.modHasConfigScreen.put(id, false);
            }
        }
        this.modList = new ModListWidgetModMenu(this.field_151, this.paneWidth, this.field_153, this.paneY, this.field_153 - 36, ModMenuConfig.COMPACT_LIST.getValue() ? 23 : 36, this.searchBox.method_1876(), this.modList, this);
        this.modList.setX(0);
        this.modList.reloadFilters();
        this.descriptionListWidget = new DescriptionListWidgetModMenu(this.field_151, this.paneWidth, this.field_153, 108, this.field_153 - 36, 9, this);
        this.descriptionListWidget.setX(this.rightPaneX);
        TexturedButtonWidget configureButton = new TexturedButtonWidget(1, this.field_152 - 24, 48, 20, 20, 0, 0, 20, CONFIGURE_BUTTON_LOCATION, 32, 64){
            private String tooltip;

            @Override
            public void method_1186(Minecraft minecraft, int mouseX, int mouseY) {
                String modId = "";
                if (ModsScreen.this.selected != null) {
                    modId = ModsScreen.this.selected.getMod().getId();
                }
                if (ModsScreen.this.selected != null) {
                    this.field_1374 = ModsScreen.this.modHasConfigScreen.get(modId);
                } else {
                    this.field_1374 = false;
                    this.field_1375 = false;
                }
                boolean bl = this.field_1375 = ModsScreen.this.selected != null && ModsScreen.this.modHasConfigScreen.get(modId) != false || ModsScreen.this.modScreenErrors.containsKey(modId);
                if (ModsScreen.this.modScreenErrors.containsKey(modId)) {
                    Throwable e = ModsScreen.this.modScreenErrors.get(modId);
                    this.tooltip = class_300.method_992().method_994("modmenu.configure.error", new Object[]{modId, modId}) + "\n\n" + e.toString();
                } else {
                    this.tooltip = CONFIGURE;
                }
                super.method_1186(minecraft, mouseX, mouseY);
            }
        };
        int urlButtonWidths = this.paneWidth / 2 - 2;
        int cappedButtonWidth = Math.min(urlButtonWidths, 200);
        class_33 websiteButton = new class_33(2, this.rightPaneX + urlButtonWidths / 2 - cappedButtonWidth / 2, 84, Math.min(urlButtonWidths, 200), 20, class_300.method_992().method_993("modmenu.website")){

            public void method_1186(Minecraft minecraft, int mouseX, int mouseY) {
                this.field_1375 = ModsScreen.this.selected != null;
                this.field_1374 = this.field_1375 && ModsScreen.this.selected.getMod().getWebsite() != null;
                super.method_1186(minecraft, mouseX, mouseY);
            }
        };
        class_33 issuesButton = new class_33(3, this.rightPaneX + urlButtonWidths + 4 + urlButtonWidths / 2 - cappedButtonWidth / 2, 84, Math.min(urlButtonWidths, 200), 20, class_300.method_992().method_993("modmenu.issues")){

            public void method_1186(Minecraft minecraft, int mouseX, int mouseY) {
                this.field_1375 = ModsScreen.this.selected != null;
                this.field_1374 = this.field_1375 && ModsScreen.this.selected.getMod().getIssueTracker() != null;
                super.method_1186(minecraft, mouseX, mouseY);
            }
        };
        TexturedButtonWidget filtersButton = new TexturedButtonWidget(4, this.paneWidth / 2 + searchBoxWidth / 2 - 10 + 2, 22, 20, 20, 0, 0, 20, FILTERS_BUTTON_LOCATION, 32, 64);
        if (!ModMenuConfig.CONFIG_MODE.getValue()) {
            this.field_154.add(filtersButton);
        }
        String showLibrariesText = ModMenuConfig.SHOW_LIBRARIES.getValueLabel();
        String sortingText = ModMenuConfig.SORTING.getValueLabel();
        int showLibrariesWidth = this.field_156.method_1901(showLibrariesText) + 20;
        int sortingWidth = this.field_156.method_1901(sortingText) + 20;
        this.filtersWidth = showLibrariesWidth + sortingWidth + 2;
        this.searchRowWidth = this.searchBoxX + searchBoxWidth + 22;
        this.updateFiltersX();
        this.field_154.add(new class_33(5, this.filtersX, 45, sortingWidth, 20, sortingText){

            public void method_1186(Minecraft minecraft, int mouseX, int mouseY) {
                this.field_1375 = ModsScreen.this.filterOptionsShown;
                this.field_1372 = ModMenuConfig.SORTING.getValueLabel();
                super.method_1186(minecraft, mouseX, mouseY);
            }
        });
        this.field_154.add(new class_33(6, this.filtersX + sortingWidth + 2, 45, showLibrariesWidth, 20, showLibrariesText){

            public void method_1186(Minecraft minecraft, int mouseX, int mouseY) {
                this.field_1375 = ModsScreen.this.filterOptionsShown;
                this.field_1372 = ModMenuConfig.SHOW_LIBRARIES.getValueLabel();
                super.method_1186(minecraft, mouseX, mouseY);
            }
        });
        if (!ModMenuConfig.HIDE_CONFIG_BUTTONS.getValue()) {
            this.field_154.add(configureButton);
        }
        this.field_154.add(websiteButton);
        this.field_154.add(issuesButton);
        this.field_154.add(new class_33(7, this.field_152 / 2 - 154, this.field_153 - 28, 150, 20, class_300.method_992().method_993("modmenu.modsFolder")));
        this.field_154.add(new class_33(8, this.field_152 / 2 + 4, this.field_153 - 28, 150, 20, class_300.method_992().method_993("gui.done")));
        this.searchBox.method_1881(true);
        this.init = true;
    }

    public void method_120(class_33 button) {
        switch (button.field_1373) {
            case 1: {
                String id = Objects.requireNonNull(this.selected).getMod().getId();
                if (this.modHasConfigScreen.get(id).booleanValue()) {
                    class_32 configScreen = ModMenu.getConfigScreen(id, this);
                    this.field_151.method_2112(configScreen);
                    break;
                }
                button.field_1374 = false;
                break;
            }
            case 2: {
                Mod mod = Objects.requireNonNull(this.selected).getMod();
                this.field_151.method_2112((class_32)new ConfirmChatLinkScreen(this, mod.getWebsite(), 2){

                    @Override
                    public void copy() {
                    }
                });
                break;
            }
            case 3: {
                Mod mod = Objects.requireNonNull(this.selected).getMod();
                this.field_151.method_2112((class_32)new ConfirmChatLinkScreen(this, mod.getIssueTracker(), 3){

                    @Override
                    public void copy() {
                    }
                });
                break;
            }
            case 4: {
                this.filterOptionsShown = !this.filterOptionsShown;
                break;
            }
            case 5: {
                ModMenuConfig.SORTING.cycleValue();
                ModMenuConfigManager.save();
                this.modList.reloadFilters();
                break;
            }
            case 6: {
                ModMenuConfig.SHOW_LIBRARIES.toggleValue();
                ModMenuConfigManager.save();
                this.modList.reloadFilters();
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                this.field_151.method_2112(this.previousScreen);
            }
        }
    }

    public void method_117(char chr, int key) {
        this.searchBox.method_1877(chr, key);
        super.method_117(chr, key);
    }

    public void method_124(int mouseX, int mouseY, int button) {
        if (this.modList.isMouseInList(mouseX, mouseY)) {
            this.modList.mouseClicked(mouseX, mouseY, button);
        }
        if (this.descriptionListWidget.isMouseInList(mouseX, mouseY)) {
            this.descriptionListWidget.mouseClicked(mouseX, mouseY, button);
        }
        super.method_124(mouseX, mouseY, button);
    }

    public void method_118(int mouseX, int mouseY, float delta) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.tooltip = null;
        this.method_127(0);
        ModListEntry selectedEntry = this.selected;
        if (selectedEntry != null) {
            this.descriptionListWidget.method_1256(mouseX, mouseY, delta);
        }
        this.modList.method_1256(mouseX, mouseY, delta);
        this.searchBox.method_1883();
        GL11.glDisable((int)3042);
        this.method_1934(this.field_156, this.title, this.modList.getWidth() / 2, 8, 0xFFFFFF);
        if (!ModMenuConfig.CONFIG_MODE.getValue()) {
            String fullModCount = this.computeModCountText(true);
            if (!ModMenuConfig.CONFIG_MODE.getValue() && this.updateFiltersX()) {
                if (this.filterOptionsShown) {
                    if (!ModMenuConfig.SHOW_LIBRARIES.getValue() || this.field_156.method_1901(fullModCount) <= this.filtersX - 5) {
                        this.field_156.method_1906(fullModCount, this.searchBoxX, 52, 0xFFFFFF);
                    } else {
                        this.field_156.method_1906(this.computeModCountText(false), this.searchBoxX, 46, 0xFFFFFF);
                        this.field_156.method_1906(this.computeLibraryCountText(), this.searchBoxX, 57, 0xFFFFFF);
                    }
                } else if (!ModMenuConfig.SHOW_LIBRARIES.getValue() || this.field_156.method_1901(fullModCount) <= this.modList.getWidth() - 5) {
                    this.field_156.method_1906(fullModCount, this.searchBoxX, 52, 0xFFFFFF);
                } else {
                    this.field_156.method_1906(this.computeModCountText(false), this.searchBoxX, 46, 0xFFFFFF);
                    this.field_156.method_1906(this.computeLibraryCountText(), this.searchBoxX, 57, 0xFFFFFF);
                }
            }
        }
        if (selectedEntry != null) {
            List<String> names;
            Mod mod = selectedEntry.getMod();
            int x = this.rightPaneX;
            if ("java".equals(mod.getId())) {
                DrawingUtil.drawRandomVersionBackground(mod, x, 48, 32, 32);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3042);
            this.selected.bindIconTexture();
            DrawingUtil.drawTexture(x, 48, 0.0f, 0.0f, 32, 32, 32.0f, 32.0f);
            GL11.glDisable((int)3042);
            int lineSpacing = 9;
            int imageOffset = 36;
            String name = mod.getTranslatedName();
            Object trimmedName = name;
            int maxNameWidth = this.field_152 - (x + imageOffset);
            if (this.field_156.method_1901(name) > maxNameWidth) {
                String ellipsis = "...";
                trimmedName = this.field_156.trim(name, maxNameWidth - this.field_156.method_1901(ellipsis)) + ellipsis;
            }
            this.field_156.method_1906((String)trimmedName, x + imageOffset, 49, 0xFFFFFF);
            if (mouseX > x + imageOffset && mouseY > 49 && mouseY < 57 && mouseX < x + imageOffset + this.field_156.method_1901((String)trimmedName)) {
                this.setTooltip(Collections.singletonList(class_300.method_992().method_994("modmenu.modIdToolTip", new Object[]{mod.getId()})));
            }
            if (this.init || this.modBadgeRenderer == null || this.modBadgeRenderer.getMod() != mod) {
                this.modBadgeRenderer = new ModBadgeRenderer(x + imageOffset + this.field_151.field_2815.method_1901((String)trimmedName) + 2, 48, this.field_152 - 28, selectedEntry.mod, this);
                this.init = false;
            }
            if (!ModMenuConfig.HIDE_BADGES.getValue()) {
                this.modBadgeRenderer.draw(mouseX, mouseY);
            }
            if (mod.isReal()) {
                this.field_156.method_1906(mod.getPrefixedVersion(), x + imageOffset, 50 + lineSpacing, 0x808080);
            }
            if (!(names = mod.getAuthors()).isEmpty()) {
                String authors = names.size() > 1 ? Joiner.on((String)", ").join(names) : names.get(0);
                DrawingUtil.drawWrappedString(class_300.method_992().method_994("modmenu.authorPrefix", new Object[]{authors}), x + imageOffset, 50 + lineSpacing * 2, this.paneWidth - imageOffset - 4, 1, 0x808080);
            }
        }
        super.method_118(mouseX, mouseY, delta);
        if (this.tooltip != null && !this.tooltip.isEmpty()) {
            this.renderTooltip(this.tooltip, mouseX, mouseY);
        }
    }

    private String computeModCountText(boolean includeLibs) {
        int[] rootMods = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && !mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
        if (includeLibs && ModMenuConfig.SHOW_LIBRARIES.getValue()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
            return TranslationUtil.translateNumeric("modmenu.showingModsLibraries", rootMods, rootLibs);
        }
        return TranslationUtil.translateNumeric("modmenu.showingMods", new int[][]{rootMods});
    }

    private String computeLibraryCountText() {
        if (ModMenuConfig.SHOW_LIBRARIES.getValue()) {
            int[] rootLibs = this.formatModCount(ModMenu.ROOT_MODS.values().stream().filter(mod -> !mod.isHidden() && mod.getBadges().contains((Object)Mod.Badge.LIBRARY)).map(Mod::getId).collect(Collectors.toSet()));
            return TranslationUtil.translateNumeric("modmenu.showingLibraries", new int[][]{rootLibs});
        }
        return "";
    }

    private int[] formatModCount(Set<String> set) {
        int total;
        int visible = this.modList.getDisplayedCountFor(set);
        if (visible == (total = set.size())) {
            return new int[]{total};
        }
        return new int[]{visible, total};
    }

    public void setTooltip(List<String> tooltip) {
        this.tooltip = tooltip;
    }

    public ModListEntry getSelectedEntry() {
        return this.selected;
    }

    public void updateSelectedEntry(ModListEntry entry) {
        if (entry != null) {
            this.selected = entry;
        }
    }

    public float getScrollPercent() {
        return this.scrollPercent;
    }

    public void updateScrollPercent(float scrollPercent) {
        this.scrollPercent = scrollPercent;
    }

    public String getSearchInput() {
        return this.searchBox.method_1876();
    }

    private boolean updateFiltersX() {
        if (this.filtersWidth + this.field_156.method_1901(this.computeModCountText(true)) + 20 >= this.searchRowWidth && (this.filtersWidth + this.field_156.method_1901(this.computeModCountText(false)) + 20 >= this.searchRowWidth || this.filtersWidth + this.field_156.method_1901(this.computeLibraryCountText()) + 20 >= this.searchRowWidth)) {
            this.filtersX = this.paneWidth / 2 - this.filtersWidth / 2;
            return !this.filterOptionsShown;
        }
        this.filtersX = this.searchRowWidth - this.filtersWidth + 1;
        return true;
    }

    private static boolean isFabricMod(Path mod) {
        boolean bl;
        JarFile jarFile = new JarFile(mod.toFile());
        try {
            bl = jarFile.getEntry("fabric.mod.json") != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    public Map<String, Boolean> getModHasConfigScreen() {
        return this.modHasConfigScreen;
    }

    public void method_126(boolean result, int id) {
        if (id < 10) {
            super.method_126(result, id);
            if (result && this.selected != null) {
                switch (id) {
                    case 2: {
                        ScreenUtil.openLink(this, this.selected.mod.getWebsite(), this.selected.mod.getId() + " /website");
                        break;
                    }
                    case 3: {
                        ScreenUtil.openLink(this, this.selected.mod.getIssueTracker(), this.selected.mod.getId() + "/issues");
                    }
                }
            }
            this.field_151.method_2112((class_32)this);
        } else {
            this.descriptionListWidget.confirmResult(result, id);
        }
    }

    protected void renderTooltip(String text, int x, int y) {
        this.renderTooltip(Collections.singletonList(text), x, y);
    }

    protected void renderTooltip(List<String> text, int x, int y) {
        int n;
        if (text.isEmpty()) {
            return;
        }
        GL11.glDisable((int)32826);
        class_583.method_1927();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int n2 = 0;
        for (String string : text) {
            n = this.field_156.method_1901(string);
            if (n <= n2) continue;
            n2 = n;
        }
        int n3 = x + 12;
        int n4 = y - 12;
        n = n2;
        int n5 = 8;
        if (text.size() > 1) {
            n5 += 2 + (text.size() - 1) * 10;
        }
        if (n3 + n2 > this.field_152) {
            n3 -= 28 + n2;
        }
        if (n4 + n5 + 6 > this.field_153) {
            n4 = this.field_153 - n5 - 6;
        }
        this.field_2522 = 300.0f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
        int n6 = -267386864;
        this.method_1933(n3 - 3, n4 - 4, n3 + n + 3, n4 - 3, n6, n6);
        this.method_1933(n3 - 3, n4 + n5 + 3, n3 + n + 3, n4 + n5 + 4, n6, n6);
        this.method_1933(n3 - 3, n4 - 3, n3 + n + 3, n4 + n5 + 3, n6, n6);
        this.method_1933(n3 - 4, n4 - 3, n3 - 3, n4 + n5 + 3, n6, n6);
        this.method_1933(n3 + n + 3, n4 - 3, n3 + n + 4, n4 + n5 + 3, n6, n6);
        int n7 = 0x505000FF;
        int n8 = (n7 & 0xFEFEFE) >> 1 | n7 & 0xFF000000;
        this.method_1933(n3 - 3, n4 - 3 + 1, n3 - 3 + 1, n4 + n5 + 3 - 1, n7, n8);
        this.method_1933(n3 + n + 2, n4 - 3 + 1, n3 + n + 3, n4 + n5 + 3 - 1, n7, n8);
        this.method_1933(n3 - 3, n4 - 3, n3 + n + 3, n4 - 3 + 1, n7, n7);
        this.method_1933(n3 - 3, n4 + n5 + 2, n3 + n + 3, n4 + n5 + 3, n8, n8);
        for (int i = 0; i < text.size(); ++i) {
            String string = text.get(i);
            this.field_156.method_1903(string, n3, n4, -1);
            if (i == 0) {
                n4 += 2;
            }
            n4 += 10;
        }
        this.field_2522 = 0.0f;
        GL11.glPopMatrix();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        class_583.method_1930();
        GL11.glEnable((int)32826);
    }
}

